package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Scte(
    scteFilter: Optional[Iterable[zio.aws.mediapackagev2.model.ScteFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.Scte = {
    import Scte.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.Scte
      .builder()
      .optionallyWith(
        scteFilter.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.scteFilterWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.Scte.ReadOnly =
    zio.aws.mediapackagev2.model.Scte.wrap(buildAwsValue())
}
object Scte {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.Scte
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.Scte =
      zio.aws.mediapackagev2.model.Scte(scteFilter.map(value => value))
    def scteFilter: Optional[List[zio.aws.mediapackagev2.model.ScteFilter]]
    def getScteFilter
        : ZIO[Any, AwsError, List[zio.aws.mediapackagev2.model.ScteFilter]] =
      AwsError.unwrapOptionField("scteFilter", scteFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.Scte
  ) extends zio.aws.mediapackagev2.model.Scte.ReadOnly {
    override val scteFilter
        : Optional[List[zio.aws.mediapackagev2.model.ScteFilter]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scteFilter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackagev2.model.ScteFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.Scte
  ): zio.aws.mediapackagev2.model.Scte.ReadOnly = new Wrapper(impl)
}
