package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetChannelGroupRequest(channelGroupName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest = {
    import GetChannelGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.GetChannelGroupRequest.ReadOnly =
    zio.aws.mediapackagev2.model.GetChannelGroupRequest.wrap(buildAwsValue())
}
object GetChannelGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.GetChannelGroupRequest =
      zio.aws.mediapackagev2.model.GetChannelGroupRequest(channelGroupName)
    def channelGroupName: ResourceName
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest
  ) extends zio.aws.mediapackagev2.model.GetChannelGroupRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest
  ): zio.aws.mediapackagev2.model.GetChannelGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
