package zio.aws.mediapackagev2.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerType {
  def unwrap: software.amazon.awssdk.services.mediapackagev2.model.ContainerType
}
object ContainerType {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagev2.model.ContainerType
  ): zio.aws.mediapackagev2.model.ContainerType = value match {
    case software.amazon.awssdk.services.mediapackagev2.model.ContainerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ContainerType.TS =>
      val r = TS
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ContainerType.CMAF =>
      val r = CMAF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagev2.model.ContainerType {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ContainerType =
      software.amazon.awssdk.services.mediapackagev2.model.ContainerType.UNKNOWN_TO_SDK_VERSION
  }
  case object TS extends zio.aws.mediapackagev2.model.ContainerType {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ContainerType =
      software.amazon.awssdk.services.mediapackagev2.model.ContainerType.TS
  }
  case object CMAF extends zio.aws.mediapackagev2.model.ContainerType {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ContainerType =
      software.amazon.awssdk.services.mediapackagev2.model.ContainerType.CMAF
  }
}
