package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.{
  ResourceDescription,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateChannelGroupRequest(
    channelGroupName: ResourceName,
    description: Optional[ResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest = {
    import UpdateChannelGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.UpdateChannelGroupRequest.ReadOnly =
    zio.aws.mediapackagev2.model.UpdateChannelGroupRequest.wrap(buildAwsValue())
}
object UpdateChannelGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.UpdateChannelGroupRequest =
      zio.aws.mediapackagev2.model.UpdateChannelGroupRequest(
        channelGroupName,
        description.map(value => value)
      )
    def channelGroupName: ResourceName
    def description: Optional[ResourceDescription]
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest
  ) extends zio.aws.mediapackagev2.model.UpdateChannelGroupRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest
  ): zio.aws.mediapackagev2.model.UpdateChannelGroupRequest.ReadOnly =
    new Wrapper(impl)
}
