package zio.aws.mediapackagev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  SegmentSegmentNameString,
  SegmentSegmentDurationSecondsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Segment(
    segmentDurationSeconds: Optional[SegmentSegmentDurationSecondsInteger] =
      Optional.Absent,
    segmentName: Optional[SegmentSegmentNameString] = Optional.Absent,
    tsUseAudioRenditionGroup: Optional[Boolean] = Optional.Absent,
    includeIframeOnlyStreams: Optional[Boolean] = Optional.Absent,
    tsIncludeDvbSubtitles: Optional[Boolean] = Optional.Absent,
    scte: Optional[zio.aws.mediapackagev2.model.Scte] = Optional.Absent,
    encryption: Optional[zio.aws.mediapackagev2.model.Encryption] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.Segment = {
    import Segment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.Segment
      .builder()
      .optionallyWith(
        segmentDurationSeconds.map(value =>
          SegmentSegmentDurationSecondsInteger.unwrap(value): Integer
        )
      )(_.segmentDurationSeconds)
      .optionallyWith(
        segmentName.map(value =>
          SegmentSegmentNameString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .optionallyWith(
        tsUseAudioRenditionGroup.map(value => value: java.lang.Boolean)
      )(_.tsUseAudioRenditionGroup)
      .optionallyWith(
        includeIframeOnlyStreams.map(value => value: java.lang.Boolean)
      )(_.includeIframeOnlyStreams)
      .optionallyWith(
        tsIncludeDvbSubtitles.map(value => value: java.lang.Boolean)
      )(_.tsIncludeDvbSubtitles)
      .optionallyWith(scte.map(value => value.buildAwsValue()))(_.scte)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.Segment.ReadOnly =
    zio.aws.mediapackagev2.model.Segment.wrap(buildAwsValue())
}
object Segment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.Segment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.Segment =
      zio.aws.mediapackagev2.model.Segment(
        segmentDurationSeconds.map(value => value),
        segmentName.map(value => value),
        tsUseAudioRenditionGroup.map(value => value),
        includeIframeOnlyStreams.map(value => value),
        tsIncludeDvbSubtitles.map(value => value),
        scte.map(value => value.asEditable),
        encryption.map(value => value.asEditable)
      )
    def segmentDurationSeconds: Optional[SegmentSegmentDurationSecondsInteger]
    def segmentName: Optional[SegmentSegmentNameString]
    def tsUseAudioRenditionGroup: Optional[Boolean]
    def includeIframeOnlyStreams: Optional[Boolean]
    def tsIncludeDvbSubtitles: Optional[Boolean]
    def scte: Optional[zio.aws.mediapackagev2.model.Scte.ReadOnly]
    def encryption: Optional[zio.aws.mediapackagev2.model.Encryption.ReadOnly]
    def getSegmentDurationSeconds
        : ZIO[Any, AwsError, SegmentSegmentDurationSecondsInteger] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getSegmentName: ZIO[Any, AwsError, SegmentSegmentNameString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
    def getTsUseAudioRenditionGroup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("tsUseAudioRenditionGroup", tsUseAudioRenditionGroup)
    def getIncludeIframeOnlyStreams: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("includeIframeOnlyStreams", includeIframeOnlyStreams)
    def getTsIncludeDvbSubtitles: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("tsIncludeDvbSubtitles", tsIncludeDvbSubtitles)
    def getScte
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.Scte.ReadOnly] =
      AwsError.unwrapOptionField("scte", scte)
    def getEncryption
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.Encryption.ReadOnly] =
      AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.Segment
  ) extends zio.aws.mediapackagev2.model.Segment.ReadOnly {
    override val segmentDurationSeconds
        : Optional[SegmentSegmentDurationSecondsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentDurationSeconds())
      .map(value =>
        zio.aws.mediapackagev2.model.primitives
          .SegmentSegmentDurationSecondsInteger(value)
      )
    override val segmentName: Optional[SegmentSegmentNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentName())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives
            .SegmentSegmentNameString(value)
        )
    override val tsUseAudioRenditionGroup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tsUseAudioRenditionGroup())
        .map(value => value: Boolean)
    override val includeIframeOnlyStreams: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeIframeOnlyStreams())
        .map(value => value: Boolean)
    override val tsIncludeDvbSubtitles: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tsIncludeDvbSubtitles())
        .map(value => value: Boolean)
    override val scte: Optional[zio.aws.mediapackagev2.model.Scte.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scte())
        .map(value => zio.aws.mediapackagev2.model.Scte.wrap(value))
    override val encryption
        : Optional[zio.aws.mediapackagev2.model.Encryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.mediapackagev2.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.Segment
  ): zio.aws.mediapackagev2.model.Segment.ReadOnly = new Wrapper(impl)
}
