package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.{PolicyText, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetOriginEndpointPolicyResponse(
    channelGroupName: ResourceName,
    channelName: ResourceName,
    originEndpointName: ResourceName,
    policy: PolicyText
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse = {
    import GetOriginEndpointPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .originEndpointName(
        ResourceName.unwrap(originEndpointName): java.lang.String
      )
      .policy(PolicyText.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly =
    zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse
      .wrap(buildAwsValue())
}
object GetOriginEndpointPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse =
      zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse(
        channelGroupName,
        channelName,
        originEndpointName,
        policy
      )
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def originEndpointName: ResourceName
    def policy: PolicyText
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getOriginEndpointName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(originEndpointName)
    def getPolicy: ZIO[Any, Nothing, PolicyText] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse
  ) extends zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val originEndpointName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.originEndpointName())
    override val policy: PolicyText =
      zio.aws.mediapackagev2.model.primitives.PolicyText(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyResponse
  ): zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
