package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteChannelPolicyRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest = {
    import DeleteChannelPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.DeleteChannelPolicyRequest.ReadOnly =
    zio.aws.mediapackagev2.model.DeleteChannelPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteChannelPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.DeleteChannelPolicyRequest =
      zio.aws.mediapackagev2.model
        .DeleteChannelPolicyRequest(channelGroupName, channelName)
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest
  ) extends zio.aws.mediapackagev2.model.DeleteChannelPolicyRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest
  ): zio.aws.mediapackagev2.model.DeleteChannelPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
