package zio.aws.mediapackagev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{ResourceDescription, Timestamp}
import scala.jdk.CollectionConverters.*
final case class ChannelListConfiguration(
    arn: String,
    channelName: String,
    channelGroupName: String,
    createdAt: Timestamp,
    modifiedAt: Timestamp,
    description: Optional[ResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ChannelListConfiguration = {
    import ChannelListConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ChannelListConfiguration
      .builder()
      .arn(arn: java.lang.String)
      .channelName(channelName: java.lang.String)
      .channelGroupName(channelGroupName: java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .modifiedAt(Timestamp.unwrap(modifiedAt): Instant)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.ChannelListConfiguration.wrap(buildAwsValue())
}
object ChannelListConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ChannelListConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ChannelListConfiguration =
      zio.aws.mediapackagev2.model.ChannelListConfiguration(
        arn,
        channelName,
        channelGroupName,
        createdAt,
        modifiedAt,
        description.map(value => value)
      )
    def arn: String
    def channelName: String
    def channelGroupName: String
    def createdAt: Timestamp
    def modifiedAt: Timestamp
    def description: Optional[ResourceDescription]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getChannelName: ZIO[Any, Nothing, String] = ZIO.succeed(channelName)
    def getChannelGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(channelGroupName)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modifiedAt)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ChannelListConfiguration
  ) extends zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly {
    override val arn: String = impl.arn(): String
    override val channelName: String = impl.channelName(): String
    override val channelGroupName: String = impl.channelGroupName(): String
    override val createdAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.createdAt())
    override val modifiedAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.modifiedAt())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ChannelListConfiguration
  ): zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly =
    new Wrapper(impl)
}
