package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.{
  ResourceDescription,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateChannelRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName,
    description: Optional[ResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.UpdateChannelRequest.ReadOnly =
    zio.aws.mediapackagev2.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.UpdateChannelRequest =
      zio.aws.mediapackagev2.model.UpdateChannelRequest(
        channelGroupName,
        channelName,
        description.map(value => value)
      )
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def description: Optional[ResourceDescription]
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest
  ) extends zio.aws.mediapackagev2.model.UpdateChannelRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest
  ): zio.aws.mediapackagev2.model.UpdateChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
