package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.{PolicyText, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutChannelPolicyRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName,
    policy: PolicyText
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest = {
    import PutChannelPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .policy(PolicyText.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.PutChannelPolicyRequest.ReadOnly =
    zio.aws.mediapackagev2.model.PutChannelPolicyRequest.wrap(buildAwsValue())
}
object PutChannelPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.PutChannelPolicyRequest =
      zio.aws.mediapackagev2.model
        .PutChannelPolicyRequest(channelGroupName, channelName, policy)
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def policy: PolicyText
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getPolicy: ZIO[Any, Nothing, PolicyText] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest
  ) extends zio.aws.mediapackagev2.model.PutChannelPolicyRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val policy: PolicyText =
      zio.aws.mediapackagev2.model.primitives.PolicyText(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest
  ): zio.aws.mediapackagev2.model.PutChannelPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
