package zio.aws.mediapackagev2
import zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.mediapackagev2.{
  MediaPackageV2AsyncClientBuilder,
  MediaPackageV2AsyncClient
}
import zio.aws.mediapackagev2.model.{
  GetChannelRequest,
  GetChannelGroupRequest,
  ListChannelGroupsRequest,
  DeleteChannelPolicyRequest,
  DeleteChannelRequest,
  CreateChannelRequest,
  GetOriginEndpointPolicyRequest,
  DeleteOriginEndpointRequest,
  ListTagsForResourceRequest,
  DeleteOriginEndpointPolicyRequest,
  ListOriginEndpointsRequest,
  UpdateOriginEndpointRequest,
  UpdateChannelRequest,
  GetOriginEndpointRequest,
  GetChannelPolicyRequest,
  UpdateChannelGroupRequest,
  ListChannelsRequest,
  PutOriginEndpointPolicyRequest,
  UntagResourceRequest,
  CreateChannelGroupRequest,
  DeleteChannelGroupRequest,
  CreateOriginEndpointRequest,
  PutChannelPolicyRequest,
  TagResourceRequest
}
import software.amazon.awssdk.services.mediapackagev2.model.{
  DeleteOriginEndpointResponse,
  ChannelGroupListConfiguration,
  GetChannelPolicyResponse,
  CreateOriginEndpointResponse,
  CreateChannelResponse,
  UpdateOriginEndpointResponse,
  UpdateChannelResponse,
  PutOriginEndpointPolicyResponse,
  GetChannelGroupResponse,
  ListChannelsResponse,
  GetChannelResponse,
  CreateChannelGroupResponse,
  OriginEndpointListConfiguration,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteChannelPolicyResponse,
  DeleteChannelGroupResponse,
  GetOriginEndpointResponse,
  GetOriginEndpointPolicyResponse,
  PutChannelPolicyResponse,
  UpdateChannelGroupResponse,
  TagResourceResponse,
  DeleteOriginEndpointPolicyResponse,
  DeleteChannelResponse,
  ListChannelGroupsResponse,
  ChannelListConfiguration,
  ListOriginEndpointsResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait MediaPackageV2 extends AspectSupport[MediaPackageV2] {
  val api: MediaPackageV2AsyncClient
  def putChannelPolicy(request: PutChannelPolicyRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.PutChannelPolicyResponse.ReadOnly
  ]
  def listChannels(
      request: ListChannelsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listChannelsPaginated(
      request: ListChannelsRequest
  ): IO[AwsError, zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly]
  def getChannelPolicy(request: GetChannelPolicyRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly
  ]
  def getChannelGroup(
      request: GetChannelGroupRequest
  ): IO[AwsError, zio.aws.mediapackagev2.model.GetChannelGroupResponse.ReadOnly]
  def updateOriginEndpoint(request: UpdateOriginEndpointRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.UpdateOriginEndpointResponse.ReadOnly
  ]
  def deleteChannel(
      request: DeleteChannelRequest
  ): IO[AwsError, zio.aws.mediapackagev2.model.DeleteChannelResponse.ReadOnly]
  def listChannelGroups(request: ListChannelGroupsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly
  ]
  def listChannelGroupsPaginated(request: ListChannelGroupsRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly
  ]
  def createChannelGroup(request: CreateChannelGroupRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.CreateChannelGroupResponse.ReadOnly
  ]
  def getOriginEndpointPolicy(request: GetOriginEndpointPolicyRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly
  ]
  def createChannel(
      request: CreateChannelRequest
  ): IO[AwsError, zio.aws.mediapackagev2.model.CreateChannelResponse.ReadOnly]
  def deleteOriginEndpoint(request: DeleteOriginEndpointRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.DeleteOriginEndpointResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def deleteChannelGroup(request: DeleteChannelGroupRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.DeleteChannelGroupResponse.ReadOnly
  ]
  def getOriginEndpoint(request: GetOriginEndpointRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.GetOriginEndpointResponse.ReadOnly
  ]
  def deleteOriginEndpointPolicy(
      request: DeleteOriginEndpointPolicyRequest
  ): IO[
    AwsError,
    zio.aws.mediapackagev2.model.DeleteOriginEndpointPolicyResponse.ReadOnly
  ]
  def getChannel(
      request: GetChannelRequest
  ): IO[AwsError, zio.aws.mediapackagev2.model.GetChannelResponse.ReadOnly]
  def updateChannelGroup(request: UpdateChannelGroupRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def createOriginEndpoint(request: CreateOriginEndpointRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly
  ]
  def putOriginEndpointPolicy(request: PutOriginEndpointPolicyRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.PutOriginEndpointPolicyResponse.ReadOnly
  ]
  def listOriginEndpoints(request: ListOriginEndpointsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
  ]
  def listOriginEndpointsPaginated(request: ListOriginEndpointsRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly
  ]
  def updateChannel(
      request: UpdateChannelRequest
  ): IO[AwsError, zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly]
  def deleteChannelPolicy(request: DeleteChannelPolicyRequest): IO[
    AwsError,
    zio.aws.mediapackagev2.model.DeleteChannelPolicyResponse.ReadOnly
  ]
}
object MediaPackageV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, MediaPackageV2] = customized(
    identity
  )
  def customized(
      customization: MediaPackageV2AsyncClientBuilder => MediaPackageV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, MediaPackageV2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: MediaPackageV2AsyncClientBuilder => MediaPackageV2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, MediaPackageV2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = MediaPackageV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[MediaPackageV2AsyncClient, MediaPackageV2AsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      MediaPackageV2AsyncClient,
      MediaPackageV2AsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new MediaPackageV2Impl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class MediaPackageV2Impl[R](
      override val api: MediaPackageV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends MediaPackageV2
      with AwsServiceBase[R] {
    override val serviceName: String = "MediaPackageV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): MediaPackageV2Impl[R1] = new MediaPackageV2Impl(api, newAspect, r)
    def putChannelPolicy(request: PutChannelPolicyRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.PutChannelPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.PutChannelPolicyRequest,
      PutChannelPolicyResponse
    ]("putChannelPolicy", api.putChannelPolicy)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.PutChannelPolicyResponse.wrap)
      .provideEnvironment(r)
    def listChannels(
        request: ListChannelsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest,
      ListChannelsResponse,
      ChannelListConfiguration
    ](
      "listChannels",
      api.listChannels,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.mediapackagev2.model.ChannelListConfiguration.wrap(item)
      )
      .provideEnvironment(r)
    def listChannelsPaginated(request: ListChannelsRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.ListChannelsRequest,
      ListChannelsResponse
    ]("listChannels", api.listChannels)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.ListChannelsResponse.wrap)
      .provideEnvironment(r)
    def getChannelPolicy(request: GetChannelPolicyRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest,
      GetChannelPolicyResponse
    ]("getChannelPolicy", api.getChannelPolicy)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.GetChannelPolicyResponse.wrap)
      .provideEnvironment(r)
    def getChannelGroup(request: GetChannelGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.GetChannelGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.GetChannelGroupRequest,
      GetChannelGroupResponse
    ]("getChannelGroup", api.getChannelGroup)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.GetChannelGroupResponse.wrap)
      .provideEnvironment(r)
    def updateOriginEndpoint(request: UpdateOriginEndpointRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.UpdateOriginEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest,
      UpdateOriginEndpointResponse
    ]("updateOriginEndpoint", api.updateOriginEndpoint)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.UpdateOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def deleteChannel(request: DeleteChannelRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.DeleteChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelRequest,
      DeleteChannelResponse
    ]("deleteChannel", api.deleteChannel)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.DeleteChannelResponse.wrap)
      .provideEnvironment(r)
    def listChannelGroups(request: ListChannelGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest,
      ListChannelGroupsResponse,
      ChannelGroupListConfiguration
    ](
      "listChannelGroups",
      api.listChannelGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.wrap(item)
      )
      .provideEnvironment(r)
    def listChannelGroupsPaginated(request: ListChannelGroupsRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest,
      ListChannelGroupsResponse
    ]("listChannelGroups", api.listChannelGroups)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.ListChannelGroupsResponse.wrap)
      .provideEnvironment(r)
    def createChannelGroup(request: CreateChannelGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.CreateChannelGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.CreateChannelGroupRequest,
      CreateChannelGroupResponse
    ]("createChannelGroup", api.createChannelGroup)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.CreateChannelGroupResponse.wrap)
      .provideEnvironment(r)
    def getOriginEndpointPolicy(request: GetOriginEndpointPolicyRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointPolicyRequest,
      GetOriginEndpointPolicyResponse
    ]("getOriginEndpointPolicy", api.getOriginEndpointPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.wrap)
      .provideEnvironment(r)
    def createChannel(request: CreateChannelRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.CreateChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.CreateChannelRequest,
      CreateChannelResponse
    ]("createChannel", api.createChannel)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.CreateChannelResponse.wrap)
      .provideEnvironment(r)
    def deleteOriginEndpoint(request: DeleteOriginEndpointRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.DeleteOriginEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointRequest,
      DeleteOriginEndpointResponse
    ]("deleteOriginEndpoint", api.deleteOriginEndpoint)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.DeleteOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackagev2.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def deleteChannelGroup(request: DeleteChannelGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.DeleteChannelGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest,
      DeleteChannelGroupResponse
    ]("deleteChannelGroup", api.deleteChannelGroup)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.DeleteChannelGroupResponse.wrap)
      .provideEnvironment(r)
    def getOriginEndpoint(request: GetOriginEndpointRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.GetOriginEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest,
      GetOriginEndpointResponse
    ]("getOriginEndpoint", api.getOriginEndpoint)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.GetOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def deleteOriginEndpointPolicy(
        request: DeleteOriginEndpointPolicyRequest
    ): IO[
      AwsError,
      zio.aws.mediapackagev2.model.DeleteOriginEndpointPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.DeleteOriginEndpointPolicyRequest,
      DeleteOriginEndpointPolicyResponse
    ]("deleteOriginEndpointPolicy", api.deleteOriginEndpointPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.mediapackagev2.model.DeleteOriginEndpointPolicyResponse.wrap)
      .provideEnvironment(r)
    def getChannel(
        request: GetChannelRequest
    ): IO[AwsError, zio.aws.mediapackagev2.model.GetChannelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackagev2.model.GetChannelRequest,
        GetChannelResponse
      ]("getChannel", api.getChannel)(request.buildAwsValue())
        .map(zio.aws.mediapackagev2.model.GetChannelResponse.wrap)
        .provideEnvironment(r)
    def updateChannelGroup(request: UpdateChannelGroupRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupRequest,
      UpdateChannelGroupResponse
    ]("updateChannelGroup", api.updateChannelGroup)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createOriginEndpoint(request: CreateOriginEndpointRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest,
      CreateOriginEndpointResponse
    ]("createOriginEndpoint", api.createOriginEndpoint)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.wrap)
      .provideEnvironment(r)
    def putOriginEndpointPolicy(request: PutOriginEndpointPolicyRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.PutOriginEndpointPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.PutOriginEndpointPolicyRequest,
      PutOriginEndpointPolicyResponse
    ]("putOriginEndpointPolicy", api.putOriginEndpointPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.mediapackagev2.model.PutOriginEndpointPolicyResponse.wrap)
      .provideEnvironment(r)
    def listOriginEndpoints(request: ListOriginEndpointsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest,
      ListOriginEndpointsResponse,
      OriginEndpointListConfiguration
    ](
      "listOriginEndpoints",
      api.listOriginEndpoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.items().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.wrap(item)
      )
      .provideEnvironment(r)
    def listOriginEndpointsPaginated(request: ListOriginEndpointsRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest,
      ListOriginEndpointsResponse
    ]("listOriginEndpoints", api.listOriginEndpoints)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.wrap)
      .provideEnvironment(r)
    def updateChannel(request: UpdateChannelRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelRequest,
      UpdateChannelResponse
    ]("updateChannel", api.updateChannel)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.UpdateChannelResponse.wrap)
      .provideEnvironment(r)
    def deleteChannelPolicy(request: DeleteChannelPolicyRequest): IO[
      AwsError,
      zio.aws.mediapackagev2.model.DeleteChannelPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelPolicyRequest,
      DeleteChannelPolicyResponse
    ]("deleteChannelPolicy", api.deleteChannelPolicy)(request.buildAwsValue())
      .map(zio.aws.mediapackagev2.model.DeleteChannelPolicyResponse.wrap)
      .provideEnvironment(r)
  }
  def putChannelPolicy(request: PutChannelPolicyRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.PutChannelPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putChannelPolicy(request))
  def listChannels(
      request: ListChannelsRequest
  ): ZStream[zio.aws.mediapackagev2.MediaPackageV2, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listChannels(request))
  def listChannelsPaginated(request: ListChannelsRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelsPaginated(request))
  def getChannelPolicy(request: GetChannelPolicyRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelPolicy(request))
  def getChannelGroup(request: GetChannelGroupRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.GetChannelGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannelGroup(request))
  def updateOriginEndpoint(request: UpdateOriginEndpointRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.UpdateOriginEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateOriginEndpoint(request))
  def deleteChannel(request: DeleteChannelRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.DeleteChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChannel(request))
  def listChannelGroups(request: ListChannelGroupsRequest): ZStream[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listChannelGroups(request))
  def listChannelGroupsPaginated(request: ListChannelGroupsRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannelGroupsPaginated(request))
  def createChannelGroup(request: CreateChannelGroupRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.CreateChannelGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannelGroup(request))
  def getOriginEndpointPolicy(request: GetOriginEndpointPolicyRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOriginEndpointPolicy(request))
  def createChannel(request: CreateChannelRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def deleteOriginEndpoint(request: DeleteOriginEndpointRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.DeleteOriginEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteOriginEndpoint(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.mediapackagev2.MediaPackageV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def deleteChannelGroup(request: DeleteChannelGroupRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.DeleteChannelGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChannelGroup(request))
  def getOriginEndpoint(request: GetOriginEndpointRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.GetOriginEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOriginEndpoint(request))
  def deleteOriginEndpointPolicy(
      request: DeleteOriginEndpointPolicyRequest
  ): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.DeleteOriginEndpointPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteOriginEndpointPolicy(request))
  def getChannel(request: GetChannelRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.GetChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannel(request))
  def updateChannelGroup(request: UpdateChannelGroupRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannelGroup(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.mediapackagev2.MediaPackageV2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createOriginEndpoint(request: CreateOriginEndpointRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOriginEndpoint(request))
  def putOriginEndpointPolicy(request: PutOriginEndpointPolicyRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.PutOriginEndpointPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putOriginEndpointPolicy(request))
  def listOriginEndpoints(request: ListOriginEndpointsRequest): ZStream[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(_.listOriginEndpoints(request))
  def listOriginEndpointsPaginated(request: ListOriginEndpointsRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOriginEndpointsPaginated(request))
  def updateChannel(request: UpdateChannelRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannel(request))
  def deleteChannelPolicy(request: DeleteChannelPolicyRequest): ZIO[
    zio.aws.mediapackagev2.MediaPackageV2,
    AwsError,
    zio.aws.mediapackagev2.model.DeleteChannelPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteChannelPolicy(request))
}
