package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.PolicyText
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetChannelPolicyResponse(
    channelGroupName: String,
    channelName: String,
    policy: PolicyText
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse = {
    import GetChannelPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse
      .builder()
      .channelGroupName(channelGroupName: java.lang.String)
      .channelName(channelName: java.lang.String)
      .policy(PolicyText.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly =
    zio.aws.mediapackagev2.model.GetChannelPolicyResponse.wrap(buildAwsValue())
}
object GetChannelPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.GetChannelPolicyResponse =
      zio.aws.mediapackagev2.model
        .GetChannelPolicyResponse(channelGroupName, channelName, policy)
    def channelGroupName: String
    def channelName: String
    def policy: PolicyText
    def getChannelGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, String] = ZIO.succeed(channelName)
    def getPolicy: ZIO[Any, Nothing, PolicyText] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse
  ) extends zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly {
    override val channelGroupName: String = impl.channelGroupName(): String
    override val channelName: String = impl.channelName(): String
    override val policy: PolicyText =
      zio.aws.mediapackagev2.model.primitives.PolicyText(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyResponse
  ): zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
