package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EncryptionMethod(
    tsEncryptionMethod: Optional[
      zio.aws.mediapackagev2.model.TsEncryptionMethod
    ] = Optional.Absent,
    cmafEncryptionMethod: Optional[
      zio.aws.mediapackagev2.model.CmafEncryptionMethod
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.EncryptionMethod = {
    import EncryptionMethod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.EncryptionMethod
      .builder()
      .optionallyWith(tsEncryptionMethod.map(value => value.unwrap))(
        _.tsEncryptionMethod
      )
      .optionallyWith(cmafEncryptionMethod.map(value => value.unwrap))(
        _.cmafEncryptionMethod
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.EncryptionMethod.ReadOnly =
    zio.aws.mediapackagev2.model.EncryptionMethod.wrap(buildAwsValue())
}
object EncryptionMethod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.EncryptionMethod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.EncryptionMethod =
      zio.aws.mediapackagev2.model.EncryptionMethod(
        tsEncryptionMethod.map(value => value),
        cmafEncryptionMethod.map(value => value)
      )
    def tsEncryptionMethod
        : Optional[zio.aws.mediapackagev2.model.TsEncryptionMethod]
    def cmafEncryptionMethod
        : Optional[zio.aws.mediapackagev2.model.CmafEncryptionMethod]
    def getTsEncryptionMethod
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.TsEncryptionMethod] =
      AwsError.unwrapOptionField("tsEncryptionMethod", tsEncryptionMethod)
    def getCmafEncryptionMethod: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagev2.model.CmafEncryptionMethod
    ] = AwsError.unwrapOptionField("cmafEncryptionMethod", cmafEncryptionMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.EncryptionMethod
  ) extends zio.aws.mediapackagev2.model.EncryptionMethod.ReadOnly {
    override val tsEncryptionMethod
        : Optional[zio.aws.mediapackagev2.model.TsEncryptionMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tsEncryptionMethod())
        .map(value =>
          zio.aws.mediapackagev2.model.TsEncryptionMethod.wrap(value)
        )
    override val cmafEncryptionMethod
        : Optional[zio.aws.mediapackagev2.model.CmafEncryptionMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cmafEncryptionMethod())
        .map(value =>
          zio.aws.mediapackagev2.model.CmafEncryptionMethod.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.EncryptionMethod
  ): zio.aws.mediapackagev2.model.EncryptionMethod.ReadOnly = new Wrapper(impl)
}
