package zio.aws.mediapackagev2
import zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly
import software.amazon.awssdk.services.mediapackagev2.MediaPackageV2AsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.mediapackagev2.model.{
  GetChannelRequest,
  GetChannelGroupRequest,
  ListChannelGroupsRequest,
  DeleteChannelPolicyRequest,
  DeleteChannelRequest,
  CreateChannelRequest,
  GetOriginEndpointPolicyRequest,
  DeleteOriginEndpointRequest,
  ListTagsForResourceRequest,
  DeleteOriginEndpointPolicyRequest,
  ListOriginEndpointsRequest,
  UpdateOriginEndpointRequest,
  UpdateChannelRequest,
  GetOriginEndpointRequest,
  GetChannelPolicyRequest,
  UpdateChannelGroupRequest,
  ListChannelsRequest,
  PutOriginEndpointPolicyRequest,
  UntagResourceRequest,
  CreateChannelGroupRequest,
  DeleteChannelGroupRequest,
  CreateOriginEndpointRequest,
  PutChannelPolicyRequest,
  TagResourceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object MediaPackageV2Mock extends Mock[MediaPackageV2] {
  object PutChannelPolicy
      extends Effect[
        PutChannelPolicyRequest,
        AwsError,
        zio.aws.mediapackagev2.model.PutChannelPolicyResponse.ReadOnly
      ]
  object ListChannels extends Stream[ListChannelsRequest, AwsError, ReadOnly]
  object ListChannelsPaginated
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly
      ]
  object GetChannelPolicy
      extends Effect[
        GetChannelPolicyRequest,
        AwsError,
        zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly
      ]
  object GetChannelGroup
      extends Effect[
        GetChannelGroupRequest,
        AwsError,
        zio.aws.mediapackagev2.model.GetChannelGroupResponse.ReadOnly
      ]
  object UpdateOriginEndpoint
      extends Effect[
        UpdateOriginEndpointRequest,
        AwsError,
        zio.aws.mediapackagev2.model.UpdateOriginEndpointResponse.ReadOnly
      ]
  object DeleteChannel
      extends Effect[
        DeleteChannelRequest,
        AwsError,
        zio.aws.mediapackagev2.model.DeleteChannelResponse.ReadOnly
      ]
  object ListChannelGroups
      extends Stream[
        ListChannelGroupsRequest,
        AwsError,
        zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly
      ]
  object ListChannelGroupsPaginated
      extends Effect[
        ListChannelGroupsRequest,
        AwsError,
        zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly
      ]
  object CreateChannelGroup
      extends Effect[
        CreateChannelGroupRequest,
        AwsError,
        zio.aws.mediapackagev2.model.CreateChannelGroupResponse.ReadOnly
      ]
  object GetOriginEndpointPolicy
      extends Effect[
        GetOriginEndpointPolicyRequest,
        AwsError,
        zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly
      ]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.mediapackagev2.model.CreateChannelResponse.ReadOnly
      ]
  object DeleteOriginEndpoint
      extends Effect[
        DeleteOriginEndpointRequest,
        AwsError,
        zio.aws.mediapackagev2.model.DeleteOriginEndpointResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object DeleteChannelGroup
      extends Effect[
        DeleteChannelGroupRequest,
        AwsError,
        zio.aws.mediapackagev2.model.DeleteChannelGroupResponse.ReadOnly
      ]
  object GetOriginEndpoint
      extends Effect[
        GetOriginEndpointRequest,
        AwsError,
        zio.aws.mediapackagev2.model.GetOriginEndpointResponse.ReadOnly
      ]
  object DeleteOriginEndpointPolicy
      extends Effect[
        DeleteOriginEndpointPolicyRequest,
        AwsError,
        zio.aws.mediapackagev2.model.DeleteOriginEndpointPolicyResponse.ReadOnly
      ]
  object GetChannel
      extends Effect[
        GetChannelRequest,
        AwsError,
        zio.aws.mediapackagev2.model.GetChannelResponse.ReadOnly
      ]
  object UpdateChannelGroup
      extends Effect[
        UpdateChannelGroupRequest,
        AwsError,
        zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.mediapackagev2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object CreateOriginEndpoint
      extends Effect[
        CreateOriginEndpointRequest,
        AwsError,
        zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly
      ]
  object PutOriginEndpointPolicy
      extends Effect[
        PutOriginEndpointPolicyRequest,
        AwsError,
        zio.aws.mediapackagev2.model.PutOriginEndpointPolicyResponse.ReadOnly
      ]
  object ListOriginEndpoints
      extends Stream[
        ListOriginEndpointsRequest,
        AwsError,
        zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
      ]
  object ListOriginEndpointsPaginated
      extends Effect[
        ListOriginEndpointsRequest,
        AwsError,
        zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly
      ]
  object UpdateChannel
      extends Effect[
        UpdateChannelRequest,
        AwsError,
        zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly
      ]
  object DeleteChannelPolicy
      extends Effect[
        DeleteChannelPolicyRequest,
        AwsError,
        zio.aws.mediapackagev2.model.DeleteChannelPolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, MediaPackageV2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, MediaPackageV2] { rts =>
        zio.ZIO.succeed {
          new MediaPackageV2 {
            val api: MediaPackageV2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): MediaPackageV2 = this
            def putChannelPolicy(request: PutChannelPolicyRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.PutChannelPolicyResponse.ReadOnly
            ] = proxy(PutChannelPolicy, request)
            def listChannels(
                request: ListChannelsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListChannels, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listChannelsPaginated(request: ListChannelsRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly
            ] = proxy(ListChannelsPaginated, request)
            def getChannelPolicy(request: GetChannelPolicyRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.GetChannelPolicyResponse.ReadOnly
            ] = proxy(GetChannelPolicy, request)
            def getChannelGroup(request: GetChannelGroupRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.GetChannelGroupResponse.ReadOnly
            ] = proxy(GetChannelGroup, request)
            def updateOriginEndpoint(request: UpdateOriginEndpointRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.UpdateOriginEndpointResponse.ReadOnly
            ] = proxy(UpdateOriginEndpoint, request)
            def deleteChannel(request: DeleteChannelRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.DeleteChannelResponse.ReadOnly
            ] = proxy(DeleteChannel, request)
            def listChannelGroups(request: ListChannelGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListChannelGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listChannelGroupsPaginated(
                request: ListChannelGroupsRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly
            ] = proxy(ListChannelGroupsPaginated, request)
            def createChannelGroup(request: CreateChannelGroupRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.CreateChannelGroupResponse.ReadOnly
            ] = proxy(CreateChannelGroup, request)
            def getOriginEndpointPolicy(
                request: GetOriginEndpointPolicyRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagev2.model.GetOriginEndpointPolicyResponse.ReadOnly
            ] = proxy(GetOriginEndpointPolicy, request)
            def createChannel(request: CreateChannelRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.CreateChannelResponse.ReadOnly
            ] = proxy(CreateChannel, request)
            def deleteOriginEndpoint(request: DeleteOriginEndpointRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.DeleteOriginEndpointResponse.ReadOnly
            ] = proxy(DeleteOriginEndpoint, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def deleteChannelGroup(request: DeleteChannelGroupRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.DeleteChannelGroupResponse.ReadOnly
            ] = proxy(DeleteChannelGroup, request)
            def getOriginEndpoint(request: GetOriginEndpointRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.GetOriginEndpointResponse.ReadOnly
            ] = proxy(GetOriginEndpoint, request)
            def deleteOriginEndpointPolicy(
                request: DeleteOriginEndpointPolicyRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagev2.model.DeleteOriginEndpointPolicyResponse.ReadOnly
            ] = proxy(DeleteOriginEndpointPolicy, request)
            def getChannel(request: GetChannelRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.GetChannelResponse.ReadOnly
            ] = proxy(GetChannel, request)
            def updateChannelGroup(request: UpdateChannelGroupRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly
            ] = proxy(UpdateChannelGroup, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def createOriginEndpoint(request: CreateOriginEndpointRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly
            ] = proxy(CreateOriginEndpoint, request)
            def putOriginEndpointPolicy(
                request: PutOriginEndpointPolicyRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagev2.model.PutOriginEndpointPolicyResponse.ReadOnly
            ] = proxy(PutOriginEndpointPolicy, request)
            def listOriginEndpoints(
                request: ListOriginEndpointsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListOriginEndpoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def listOriginEndpointsPaginated(
                request: ListOriginEndpointsRequest
            ): IO[
              AwsError,
              zio.aws.mediapackagev2.model.ListOriginEndpointsResponse.ReadOnly
            ] = proxy(ListOriginEndpointsPaginated, request)
            def updateChannel(request: UpdateChannelRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.UpdateChannelResponse.ReadOnly
            ] = proxy(UpdateChannel, request)
            def deleteChannelPolicy(request: DeleteChannelPolicyRequest): IO[
              AwsError,
              zio.aws.mediapackagev2.model.DeleteChannelPolicyResponse.ReadOnly
            ] = proxy(DeleteChannelPolicy, request)
          }
        }
      }
    }
  }
}
