package zio.aws.mediapackagev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  Timestamp,
  ResourceDescription,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class OriginEndpointListConfiguration(
    arn: String,
    channelGroupName: ResourceName,
    channelName: ResourceName,
    originEndpointName: ResourceName,
    containerType: zio.aws.mediapackagev2.model.ContainerType,
    description: Optional[ResourceDescription] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    modifiedAt: Optional[Timestamp] = Optional.Absent,
    hlsManifests: Optional[
      Iterable[zio.aws.mediapackagev2.model.ListHlsManifestConfiguration]
    ] = Optional.Absent,
    lowLatencyHlsManifests: Optional[Iterable[
      zio.aws.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.OriginEndpointListConfiguration = {
    import OriginEndpointListConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.OriginEndpointListConfiguration
      .builder()
      .arn(arn: java.lang.String)
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .originEndpointName(
        ResourceName.unwrap(originEndpointName): java.lang.String
      )
      .containerType(containerType.unwrap)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        modifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAt)
      .optionallyWith(
        hlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hlsManifests)
      .optionallyWith(
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lowLatencyHlsManifests)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.OriginEndpointListConfiguration
      .wrap(buildAwsValue())
}
object OriginEndpointListConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.OriginEndpointListConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagev2.model.OriginEndpointListConfiguration =
      zio.aws.mediapackagev2.model.OriginEndpointListConfiguration(
        arn,
        channelGroupName,
        channelName,
        originEndpointName,
        containerType,
        description.map(value => value),
        createdAt.map(value => value),
        modifiedAt.map(value => value),
        hlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: String
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def originEndpointName: ResourceName
    def containerType: zio.aws.mediapackagev2.model.ContainerType
    def description: Optional[ResourceDescription]
    def createdAt: Optional[Timestamp]
    def modifiedAt: Optional[Timestamp]
    def hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.ListHlsManifestConfiguration.ReadOnly]
    ]
    def lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration.ReadOnly
    ]]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getOriginEndpointName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(originEndpointName)
    def getContainerType
        : ZIO[Any, Nothing, zio.aws.mediapackagev2.model.ContainerType] =
      ZIO.succeed(containerType)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
    def getHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.ListHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("hlsManifests", hlsManifests)
    def getLowLatencyHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lowLatencyHlsManifests",
      lowLatencyHlsManifests
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.OriginEndpointListConfiguration
  ) extends zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly {
    override val arn: String = impl.arn(): String
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val originEndpointName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.originEndpointName())
    override val containerType: zio.aws.mediapackagev2.model.ContainerType =
      zio.aws.mediapackagev2.model.ContainerType.wrap(impl.containerType())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.mediapackagev2.model.primitives.Timestamp(value))
    override val modifiedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedAt())
      .map(value => zio.aws.mediapackagev2.model.primitives.Timestamp(value))
    override val hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.ListHlsManifestConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.ListHlsManifestConfiguration.wrap(item)
        }.toList
      )
    override val lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.lowLatencyHlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.OriginEndpointListConfiguration
  ): zio.aws.mediapackagev2.model.OriginEndpointListConfiguration.ReadOnly =
    new Wrapper(impl)
}
