package zio.aws.mediapackagev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  TagValue,
  TagKey,
  ResourceDescription,
  Timestamp
}
import scala.jdk.CollectionConverters._
final case class UpdateChannelGroupResponse(
    channelGroupName: String,
    arn: String,
    egressDomain: String,
    createdAt: Timestamp,
    modifiedAt: Timestamp,
    description: Optional[ResourceDescription] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse = {
    import UpdateChannelGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse
      .builder()
      .channelGroupName(channelGroupName: java.lang.String)
      .arn(arn: java.lang.String)
      .egressDomain(egressDomain: java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .modifiedAt(Timestamp.unwrap(modifiedAt): Instant)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly =
    zio.aws.mediapackagev2.model.UpdateChannelGroupResponse
      .wrap(buildAwsValue())
}
object UpdateChannelGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.UpdateChannelGroupResponse =
      zio.aws.mediapackagev2.model.UpdateChannelGroupResponse(
        channelGroupName,
        arn,
        egressDomain,
        createdAt,
        modifiedAt,
        description.map(value => value),
        tags.map(value => value)
      )
    def channelGroupName: String
    def arn: String
    def egressDomain: String
    def createdAt: Timestamp
    def modifiedAt: Timestamp
    def description: Optional[ResourceDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def getChannelGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(channelGroupName)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getEgressDomain: ZIO[Any, Nothing, String] = ZIO.succeed(egressDomain)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modifiedAt)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse
  ) extends zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly {
    override val channelGroupName: String = impl.channelGroupName(): String
    override val arn: String = impl.arn(): String
    override val egressDomain: String = impl.egressDomain(): String
    override val createdAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.createdAt())
    override val modifiedAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.modifiedAt())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediapackagev2.model.primitives.TagKey(
              key
            ) -> zio.aws.mediapackagev2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateChannelGroupResponse
  ): zio.aws.mediapackagev2.model.UpdateChannelGroupResponse.ReadOnly =
    new Wrapper(impl)
}
