package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.{TagValue, TagKey, TagArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: TagArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest
      .builder()
      .resourceArn(TagArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.TagResourceRequest.ReadOnly =
    zio.aws.mediapackagev2.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.TagResourceRequest =
      zio.aws.mediapackagev2.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: TagArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, TagArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest
  ) extends zio.aws.mediapackagev2.model.TagResourceRequest.ReadOnly {
    override val resourceArn: TagArn =
      zio.aws.mediapackagev2.model.primitives.TagArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.mediapackagev2.model.primitives.TagKey(
          key
        ) -> zio.aws.mediapackagev2.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.TagResourceRequest
  ): zio.aws.mediapackagev2.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
