package zio.aws.mediapackagev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  UpdateOriginEndpointRequestStartoverWindowSecondsInteger,
  ResourceDescription,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateOriginEndpointRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName,
    originEndpointName: ResourceName,
    containerType: zio.aws.mediapackagev2.model.ContainerType,
    segment: Optional[zio.aws.mediapackagev2.model.Segment] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    startoverWindowSeconds: Optional[
      UpdateOriginEndpointRequestStartoverWindowSecondsInteger
    ] = Optional.Absent,
    hlsManifests: Optional[
      Iterable[zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration]
    ] = Optional.Absent,
    lowLatencyHlsManifests: Optional[Iterable[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest = {
    import UpdateOriginEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .originEndpointName(
        ResourceName.unwrap(originEndpointName): java.lang.String
      )
      .containerType(containerType.unwrap)
      .optionallyWith(segment.map(value => value.buildAwsValue()))(_.segment)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        startoverWindowSeconds.map(value =>
          UpdateOriginEndpointRequestStartoverWindowSecondsInteger.unwrap(
            value
          ): Integer
        )
      )(_.startoverWindowSeconds)
      .optionallyWith(
        hlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hlsManifests)
      .optionallyWith(
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lowLatencyHlsManifests)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.UpdateOriginEndpointRequest.ReadOnly =
    zio.aws.mediapackagev2.model.UpdateOriginEndpointRequest
      .wrap(buildAwsValue())
}
object UpdateOriginEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.UpdateOriginEndpointRequest =
      zio.aws.mediapackagev2.model.UpdateOriginEndpointRequest(
        channelGroupName,
        channelName,
        originEndpointName,
        containerType,
        segment.map(value => value.asEditable),
        description.map(value => value),
        startoverWindowSeconds.map(value => value),
        hlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def originEndpointName: ResourceName
    def containerType: zio.aws.mediapackagev2.model.ContainerType
    def segment: Optional[zio.aws.mediapackagev2.model.Segment.ReadOnly]
    def description: Optional[ResourceDescription]
    def startoverWindowSeconds
        : Optional[UpdateOriginEndpointRequestStartoverWindowSecondsInteger]
    def hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.ReadOnly]
    ]
    def lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly
    ]]
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getOriginEndpointName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(originEndpointName)
    def getContainerType
        : ZIO[Any, Nothing, zio.aws.mediapackagev2.model.ContainerType] =
      ZIO.succeed(containerType)
    def getSegment
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.Segment.ReadOnly] =
      AwsError.unwrapOptionField("segment", segment)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStartoverWindowSeconds: ZIO[
      Any,
      AwsError,
      UpdateOriginEndpointRequestStartoverWindowSecondsInteger
    ] = AwsError.unwrapOptionField(
      "startoverWindowSeconds",
      startoverWindowSeconds
    )
    def getHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("hlsManifests", hlsManifests)
    def getLowLatencyHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lowLatencyHlsManifests",
      lowLatencyHlsManifests
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest
  ) extends zio.aws.mediapackagev2.model.UpdateOriginEndpointRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val originEndpointName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.originEndpointName())
    override val containerType: zio.aws.mediapackagev2.model.ContainerType =
      zio.aws.mediapackagev2.model.ContainerType.wrap(impl.containerType())
    override val segment
        : Optional[zio.aws.mediapackagev2.model.Segment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segment())
        .map(value => zio.aws.mediapackagev2.model.Segment.wrap(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
    override val startoverWindowSeconds
        : Optional[UpdateOriginEndpointRequestStartoverWindowSecondsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startoverWindowSeconds())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives
            .UpdateOriginEndpointRequestStartoverWindowSecondsInteger(value)
        )
    override val hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.wrap(item)
        }.toList
      )
    override val lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.lowLatencyHlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.UpdateOriginEndpointRequest
  ): zio.aws.mediapackagev2.model.UpdateOriginEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
