package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.TagArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: TagArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(TagArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.mediapackagev2.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ListTagsForResourceRequest =
      zio.aws.mediapackagev2.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: TagArn
    def getResourceArn: ZIO[Any, Nothing, TagArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest
  ) extends zio.aws.mediapackagev2.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: TagArn =
      zio.aws.mediapackagev2.model.primitives.TagArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListTagsForResourceRequest
  ): zio.aws.mediapackagev2.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
