package zio.aws.mediapackagev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.ListResourceMaxResults
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelGroupsRequest(
    maxResults: Optional[ListResourceMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest = {
    import ListChannelGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => ListResourceMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ListChannelGroupsRequest.ReadOnly =
    zio.aws.mediapackagev2.model.ListChannelGroupsRequest.wrap(buildAwsValue())
}
object ListChannelGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ListChannelGroupsRequest =
      zio.aws.mediapackagev2.model.ListChannelGroupsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListResourceMaxResults]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, ListResourceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest
  ) extends zio.aws.mediapackagev2.model.ListChannelGroupsRequest.ReadOnly {
    override val maxResults: Optional[ListResourceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ListResourceMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsRequest
  ): zio.aws.mediapackagev2.model.ListChannelGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
