package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IngestEndpoint(
    id: Optional[String] = Optional.Absent,
    url: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint = {
    import IngestEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.IngestEndpoint.ReadOnly =
    zio.aws.mediapackagev2.model.IngestEndpoint.wrap(buildAwsValue())
}
object IngestEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.IngestEndpoint =
      zio.aws.mediapackagev2.model
        .IngestEndpoint(id.map(value => value), url.map(value => value))
    def id: Optional[String]
    def url: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint
  ) extends zio.aws.mediapackagev2.model.IngestEndpoint.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.IngestEndpoint
  ): zio.aws.mediapackagev2.model.IngestEndpoint.ReadOnly = new Wrapper(impl)
}
