package zio.aws.mediapackagev2.model
import scala.jdk.CollectionConverters._
sealed trait DrmSystem {
  def unwrap: software.amazon.awssdk.services.mediapackagev2.model.DrmSystem
}
object DrmSystem {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagev2.model.DrmSystem
  ): zio.aws.mediapackagev2.model.DrmSystem = value match {
    case software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.CLEAR_KEY_AES_128 =>
      val r = CLEAR_KEY_AES_128
      r
    case software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.FAIRPLAY =>
      val r = FAIRPLAY
      r
    case software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.PLAYREADY =>
      val r = PLAYREADY
      r
    case software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.WIDEVINE =>
      val r = WIDEVINE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagev2.model.DrmSystem {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.DrmSystem =
      software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.UNKNOWN_TO_SDK_VERSION
  }
  case object CLEAR_KEY_AES_128 extends zio.aws.mediapackagev2.model.DrmSystem {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.DrmSystem =
      software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.CLEAR_KEY_AES_128
  }
  case object FAIRPLAY extends zio.aws.mediapackagev2.model.DrmSystem {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.DrmSystem =
      software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.FAIRPLAY
  }
  case object PLAYREADY extends zio.aws.mediapackagev2.model.DrmSystem {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.DrmSystem =
      software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.PLAYREADY
  }
  case object WIDEVINE extends zio.aws.mediapackagev2.model.DrmSystem {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.DrmSystem =
      software.amazon.awssdk.services.mediapackagev2.model.DrmSystem.WIDEVINE
  }
}
