package zio.aws.mediapackagev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  ResourceDescription,
  Timestamp,
  TagValue,
  Integer,
  ResourceName,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateOriginEndpointResponse(
    arn: String,
    channelGroupName: ResourceName,
    channelName: ResourceName,
    originEndpointName: ResourceName,
    containerType: zio.aws.mediapackagev2.model.ContainerType,
    segment: zio.aws.mediapackagev2.model.Segment,
    createdAt: Timestamp,
    modifiedAt: Timestamp,
    description: Optional[ResourceDescription] = Optional.Absent,
    startoverWindowSeconds: Optional[Integer] = Optional.Absent,
    hlsManifests: Optional[
      Iterable[zio.aws.mediapackagev2.model.GetHlsManifestConfiguration]
    ] = Optional.Absent,
    lowLatencyHlsManifests: Optional[Iterable[
      zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
    ]] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse = {
    import CreateOriginEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse
      .builder()
      .arn(arn: java.lang.String)
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .originEndpointName(
        ResourceName.unwrap(originEndpointName): java.lang.String
      )
      .containerType(containerType.unwrap)
      .segment(segment.buildAwsValue())
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .modifiedAt(Timestamp.unwrap(modifiedAt): Instant)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        startoverWindowSeconds.map(value => value: java.lang.Integer)
      )(_.startoverWindowSeconds)
      .optionallyWith(
        hlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hlsManifests)
      .optionallyWith(
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lowLatencyHlsManifests)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly =
    zio.aws.mediapackagev2.model.CreateOriginEndpointResponse
      .wrap(buildAwsValue())
}
object CreateOriginEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.CreateOriginEndpointResponse =
      zio.aws.mediapackagev2.model.CreateOriginEndpointResponse(
        arn,
        channelGroupName,
        channelName,
        originEndpointName,
        containerType,
        segment.asEditable,
        createdAt,
        modifiedAt,
        description.map(value => value),
        startoverWindowSeconds.map(value => value),
        hlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def arn: String
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def originEndpointName: ResourceName
    def containerType: zio.aws.mediapackagev2.model.ContainerType
    def segment: zio.aws.mediapackagev2.model.Segment.ReadOnly
    def createdAt: Timestamp
    def modifiedAt: Timestamp
    def description: Optional[ResourceDescription]
    def startoverWindowSeconds: Optional[Integer]
    def hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.GetHlsManifestConfiguration.ReadOnly]
    ]
    def lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.ReadOnly
    ]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getOriginEndpointName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(originEndpointName)
    def getContainerType
        : ZIO[Any, Nothing, zio.aws.mediapackagev2.model.ContainerType] =
      ZIO.succeed(containerType)
    def getSegment
        : ZIO[Any, Nothing, zio.aws.mediapackagev2.model.Segment.ReadOnly] =
      ZIO.succeed(segment)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modifiedAt)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStartoverWindowSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("startoverWindowSeconds", startoverWindowSeconds)
    def getHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.GetHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("hlsManifests", hlsManifests)
    def getLowLatencyHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lowLatencyHlsManifests",
      lowLatencyHlsManifests
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse
  ) extends zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly {
    override val arn: String = impl.arn(): String
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val originEndpointName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.originEndpointName())
    override val containerType: zio.aws.mediapackagev2.model.ContainerType =
      zio.aws.mediapackagev2.model.ContainerType.wrap(impl.containerType())
    override val segment: zio.aws.mediapackagev2.model.Segment.ReadOnly =
      zio.aws.mediapackagev2.model.Segment.wrap(impl.segment())
    override val createdAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.createdAt())
    override val modifiedAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.modifiedAt())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
    override val startoverWindowSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startoverWindowSeconds())
        .map(value => value: Integer)
    override val hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.GetHlsManifestConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.GetHlsManifestConfiguration.wrap(item)
        }.toList
      )
    override val lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.lowLatencyHlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
            .wrap(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediapackagev2.model.primitives.TagKey(
              key
            ) -> zio.aws.mediapackagev2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointResponse
  ): zio.aws.mediapackagev2.model.CreateOriginEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
