package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListHlsManifestConfiguration(
    manifestName: ResourceName,
    childManifestName: Optional[ResourceName] = Optional.Absent,
    url: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration = {
    import ListHlsManifestConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration
      .builder()
      .manifestName(ResourceName.unwrap(manifestName): java.lang.String)
      .optionallyWith(
        childManifestName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.childManifestName)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ListHlsManifestConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.ListHlsManifestConfiguration
      .wrap(buildAwsValue())
}
object ListHlsManifestConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ListHlsManifestConfiguration =
      zio.aws.mediapackagev2.model.ListHlsManifestConfiguration(
        manifestName,
        childManifestName.map(value => value),
        url.map(value => value)
      )
    def manifestName: ResourceName
    def childManifestName: Optional[ResourceName]
    def url: Optional[String]
    def getManifestName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(manifestName)
    def getChildManifestName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("childManifestName", childManifestName)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration
  ) extends zio.aws.mediapackagev2.model.ListHlsManifestConfiguration.ReadOnly {
    override val manifestName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.manifestName())
    override val childManifestName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childManifestName())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceName(value)
        )
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration
  ): zio.aws.mediapackagev2.model.ListHlsManifestConfiguration.ReadOnly =
    new Wrapper(impl)
}
