package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelsResponse(
    items: Optional[
      Iterable[zio.aws.mediapackagev2.model.ChannelListConfiguration]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly =
    zio.aws.mediapackagev2.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ListChannelsResponse =
      zio.aws.mediapackagev2.model.ListChannelsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[
      List[zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse
  ) extends zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.mediapackagev2.model.ChannelListConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.ChannelListConfiguration.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListChannelsResponse
  ): zio.aws.mediapackagev2.model.ListChannelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
