package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelGroupsResponse(
    items: Optional[
      Iterable[zio.aws.mediapackagev2.model.ChannelGroupListConfiguration]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse = {
    import ListChannelGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly =
    zio.aws.mediapackagev2.model.ListChannelGroupsResponse.wrap(buildAwsValue())
}
object ListChannelGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ListChannelGroupsResponse =
      zio.aws.mediapackagev2.model.ListChannelGroupsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items: Optional[
      List[zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse
  ) extends zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListChannelGroupsResponse
  ): zio.aws.mediapackagev2.model.ListChannelGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
