package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetOriginEndpointRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName,
    originEndpointName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest = {
    import GetOriginEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .originEndpointName(
        ResourceName.unwrap(originEndpointName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.GetOriginEndpointRequest.ReadOnly =
    zio.aws.mediapackagev2.model.GetOriginEndpointRequest.wrap(buildAwsValue())
}
object GetOriginEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.GetOriginEndpointRequest =
      zio.aws.mediapackagev2.model.GetOriginEndpointRequest(
        channelGroupName,
        channelName,
        originEndpointName
      )
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def originEndpointName: ResourceName
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getOriginEndpointName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(originEndpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest
  ) extends zio.aws.mediapackagev2.model.GetOriginEndpointRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val originEndpointName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.originEndpointName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetOriginEndpointRequest
  ): zio.aws.mediapackagev2.model.GetOriginEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
