package zio.aws.mediapackagev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  FilterConfigurationTimeDelaySecondsInteger,
  Timestamp,
  FilterConfigurationManifestFilterString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FilterConfiguration(
    manifestFilter: Optional[FilterConfigurationManifestFilterString] =
      Optional.Absent,
    start: Optional[Timestamp] = Optional.Absent,
    end: Optional[Timestamp] = Optional.Absent,
    timeDelaySeconds: Optional[FilterConfigurationTimeDelaySecondsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration = {
    import FilterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration
      .builder()
      .optionallyWith(
        manifestFilter.map(value =>
          FilterConfigurationManifestFilterString.unwrap(
            value
          ): java.lang.String
        )
      )(_.manifestFilter)
      .optionallyWith(start.map(value => Timestamp.unwrap(value): Instant))(
        _.start
      )
      .optionallyWith(end.map(value => Timestamp.unwrap(value): Instant))(_.end)
      .optionallyWith(
        timeDelaySeconds.map(value =>
          FilterConfigurationTimeDelaySecondsInteger.unwrap(value): Integer
        )
      )(_.timeDelaySeconds)
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.FilterConfiguration.wrap(buildAwsValue())
}
object FilterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.FilterConfiguration =
      zio.aws.mediapackagev2.model.FilterConfiguration(
        manifestFilter.map(value => value),
        start.map(value => value),
        end.map(value => value),
        timeDelaySeconds.map(value => value)
      )
    def manifestFilter: Optional[FilterConfigurationManifestFilterString]
    def start: Optional[Timestamp]
    def end: Optional[Timestamp]
    def timeDelaySeconds: Optional[FilterConfigurationTimeDelaySecondsInteger]
    def getManifestFilter
        : ZIO[Any, AwsError, FilterConfigurationManifestFilterString] =
      AwsError.unwrapOptionField("manifestFilter", manifestFilter)
    def getStart: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("end", end)
    def getTimeDelaySeconds
        : ZIO[Any, AwsError, FilterConfigurationTimeDelaySecondsInteger] =
      AwsError.unwrapOptionField("timeDelaySeconds", timeDelaySeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration
  ) extends zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly {
    override val manifestFilter
        : Optional[FilterConfigurationManifestFilterString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestFilter())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives
            .FilterConfigurationManifestFilterString(value)
        )
    override val start: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.mediapackagev2.model.primitives.Timestamp(value))
    override val end: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => zio.aws.mediapackagev2.model.primitives.Timestamp(value))
    override val timeDelaySeconds
        : Optional[FilterConfigurationTimeDelaySecondsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeDelaySeconds())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives
            .FilterConfigurationTimeDelaySecondsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.FilterConfiguration
  ): zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
