package zio.aws.mediapackagev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  EncryptionKeyRotationIntervalSecondsInteger,
  EncryptionConstantInitializationVectorString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Encryption(
    constantInitializationVector: Optional[
      EncryptionConstantInitializationVectorString
    ] = Optional.Absent,
    encryptionMethod: zio.aws.mediapackagev2.model.EncryptionMethod,
    keyRotationIntervalSeconds: Optional[
      EncryptionKeyRotationIntervalSecondsInteger
    ] = Optional.Absent,
    spekeKeyProvider: zio.aws.mediapackagev2.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.Encryption = {
    import Encryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.Encryption
      .builder()
      .optionallyWith(
        constantInitializationVector.map(value =>
          EncryptionConstantInitializationVectorString.unwrap(
            value
          ): java.lang.String
        )
      )(_.constantInitializationVector)
      .encryptionMethod(encryptionMethod.buildAwsValue())
      .optionallyWith(
        keyRotationIntervalSeconds.map(value =>
          EncryptionKeyRotationIntervalSecondsInteger.unwrap(value): Integer
        )
      )(_.keyRotationIntervalSeconds)
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackagev2.model.Encryption.ReadOnly =
    zio.aws.mediapackagev2.model.Encryption.wrap(buildAwsValue())
}
object Encryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.Encryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.Encryption =
      zio.aws.mediapackagev2.model.Encryption(
        constantInitializationVector.map(value => value),
        encryptionMethod.asEditable,
        keyRotationIntervalSeconds.map(value => value),
        spekeKeyProvider.asEditable
      )
    def constantInitializationVector
        : Optional[EncryptionConstantInitializationVectorString]
    def encryptionMethod: zio.aws.mediapackagev2.model.EncryptionMethod.ReadOnly
    def keyRotationIntervalSeconds
        : Optional[EncryptionKeyRotationIntervalSecondsInteger]
    def spekeKeyProvider: zio.aws.mediapackagev2.model.SpekeKeyProvider.ReadOnly
    def getConstantInitializationVector
        : ZIO[Any, AwsError, EncryptionConstantInitializationVectorString] =
      AwsError.unwrapOptionField(
        "constantInitializationVector",
        constantInitializationVector
      )
    def getEncryptionMethod: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackagev2.model.EncryptionMethod.ReadOnly
    ] = ZIO.succeed(encryptionMethod)
    def getKeyRotationIntervalSeconds
        : ZIO[Any, AwsError, EncryptionKeyRotationIntervalSecondsInteger] =
      AwsError.unwrapOptionField(
        "keyRotationIntervalSeconds",
        keyRotationIntervalSeconds
      )
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackagev2.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.Encryption
  ) extends zio.aws.mediapackagev2.model.Encryption.ReadOnly {
    override val constantInitializationVector
        : Optional[EncryptionConstantInitializationVectorString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constantInitializationVector())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives
            .EncryptionConstantInitializationVectorString(value)
        )
    override val encryptionMethod
        : zio.aws.mediapackagev2.model.EncryptionMethod.ReadOnly =
      zio.aws.mediapackagev2.model.EncryptionMethod
        .wrap(impl.encryptionMethod())
    override val keyRotationIntervalSeconds
        : Optional[EncryptionKeyRotationIntervalSecondsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyRotationIntervalSeconds())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives
            .EncryptionKeyRotationIntervalSecondsInteger(value)
        )
    override val spekeKeyProvider
        : zio.aws.mediapackagev2.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackagev2.model.SpekeKeyProvider
        .wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.Encryption
  ): zio.aws.mediapackagev2.model.Encryption.ReadOnly = new Wrapper(impl)
}
