package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteChannelGroupRequest(channelGroupName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest = {
    import DeleteChannelGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.DeleteChannelGroupRequest.ReadOnly =
    zio.aws.mediapackagev2.model.DeleteChannelGroupRequest.wrap(buildAwsValue())
}
object DeleteChannelGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.DeleteChannelGroupRequest =
      zio.aws.mediapackagev2.model.DeleteChannelGroupRequest(channelGroupName)
    def channelGroupName: ResourceName
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest
  ) extends zio.aws.mediapackagev2.model.DeleteChannelGroupRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.DeleteChannelGroupRequest
  ): zio.aws.mediapackagev2.model.DeleteChannelGroupRequest.ReadOnly =
    new Wrapper(impl)
}
