package zio.aws.mediapackagev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger,
  CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger,
  ManifestName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateLowLatencyHlsManifestConfiguration(
    manifestName: ManifestName,
    childManifestName: Optional[ManifestName] = Optional.Absent,
    scteHls: Optional[zio.aws.mediapackagev2.model.ScteHls] = Optional.Absent,
    manifestWindowSeconds: Optional[
      CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger
    ] = Optional.Absent,
    programDateTimeIntervalSeconds: Optional[
      CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger
    ] = Optional.Absent,
    filterConfiguration: Optional[
      zio.aws.mediapackagev2.model.FilterConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration = {
    import CreateLowLatencyHlsManifestConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
      .builder()
      .manifestName(ManifestName.unwrap(manifestName): java.lang.String)
      .optionallyWith(
        childManifestName.map(value =>
          ManifestName.unwrap(value): java.lang.String
        )
      )(_.childManifestName)
      .optionallyWith(scteHls.map(value => value.buildAwsValue()))(_.scteHls)
      .optionallyWith(
        manifestWindowSeconds.map(value =>
          CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger
            .unwrap(value): Integer
        )
      )(_.manifestWindowSeconds)
      .optionallyWith(
        programDateTimeIntervalSeconds.map(value =>
          CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger
            .unwrap(value): Integer
        )
      )(_.programDateTimeIntervalSeconds)
      .optionallyWith(filterConfiguration.map(value => value.buildAwsValue()))(
        _.filterConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
      .wrap(buildAwsValue())
}
object CreateLowLatencyHlsManifestConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration =
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration(
        manifestName,
        childManifestName.map(value => value),
        scteHls.map(value => value.asEditable),
        manifestWindowSeconds.map(value => value),
        programDateTimeIntervalSeconds.map(value => value),
        filterConfiguration.map(value => value.asEditable)
      )
    def manifestName: ManifestName
    def childManifestName: Optional[ManifestName]
    def scteHls: Optional[zio.aws.mediapackagev2.model.ScteHls.ReadOnly]
    def manifestWindowSeconds: Optional[
      CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger
    ]
    def programDateTimeIntervalSeconds: Optional[
      CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger
    ]
    def filterConfiguration
        : Optional[zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly]
    def getManifestName: ZIO[Any, Nothing, ManifestName] =
      ZIO.succeed(manifestName)
    def getChildManifestName: ZIO[Any, AwsError, ManifestName] =
      AwsError.unwrapOptionField("childManifestName", childManifestName)
    def getScteHls
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.ScteHls.ReadOnly] =
      AwsError.unwrapOptionField("scteHls", scteHls)
    def getManifestWindowSeconds: ZIO[
      Any,
      AwsError,
      CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger
    ] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
    def getProgramDateTimeIntervalSeconds: ZIO[
      Any,
      AwsError,
      CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger
    ] = AwsError.unwrapOptionField(
      "programDateTimeIntervalSeconds",
      programDateTimeIntervalSeconds
    )
    def getFilterConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("filterConfiguration", filterConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
  ) extends zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly {
    override val manifestName: ManifestName =
      zio.aws.mediapackagev2.model.primitives.ManifestName(impl.manifestName())
    override val childManifestName: Optional[ManifestName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childManifestName())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ManifestName(value)
        )
    override val scteHls
        : Optional[zio.aws.mediapackagev2.model.ScteHls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scteHls())
        .map(value => zio.aws.mediapackagev2.model.ScteHls.wrap(value))
    override val manifestWindowSeconds: Optional[
      CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.manifestWindowSeconds())
      .map(value =>
        zio.aws.mediapackagev2.model.primitives
          .CreateLowLatencyHlsManifestConfigurationManifestWindowSecondsInteger(
            value
          )
      )
    override val programDateTimeIntervalSeconds: Optional[
      CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.programDateTimeIntervalSeconds())
      .map(value =>
        zio.aws.mediapackagev2.model.primitives
          .CreateLowLatencyHlsManifestConfigurationProgramDateTimeIntervalSecondsInteger(
            value
          )
      )
    override val filterConfiguration
        : Optional[zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterConfiguration())
        .map(value =>
          zio.aws.mediapackagev2.model.FilterConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
  ): zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly =
    new Wrapper(impl)
}
