package zio.aws.mediapackagev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  ListResourceMaxResults,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListOriginEndpointsRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName,
    maxResults: Optional[ListResourceMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest = {
    import ListOriginEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => ListResourceMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ListOriginEndpointsRequest.ReadOnly =
    zio.aws.mediapackagev2.model.ListOriginEndpointsRequest
      .wrap(buildAwsValue())
}
object ListOriginEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ListOriginEndpointsRequest =
      zio.aws.mediapackagev2.model.ListOriginEndpointsRequest(
        channelGroupName,
        channelName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def maxResults: Optional[ListResourceMaxResults]
    def nextToken: Optional[String]
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getMaxResults: ZIO[Any, AwsError, ListResourceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest
  ) extends zio.aws.mediapackagev2.model.ListOriginEndpointsRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val maxResults: Optional[ListResourceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ListResourceMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ListOriginEndpointsRequest
  ): zio.aws.mediapackagev2.model.ListOriginEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
