package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetChannelPolicyRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest = {
    import GetChannelPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.GetChannelPolicyRequest.ReadOnly =
    zio.aws.mediapackagev2.model.GetChannelPolicyRequest.wrap(buildAwsValue())
}
object GetChannelPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.GetChannelPolicyRequest =
      zio.aws.mediapackagev2.model
        .GetChannelPolicyRequest(channelGroupName, channelName)
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest
  ) extends zio.aws.mediapackagev2.model.GetChannelPolicyRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetChannelPolicyRequest
  ): zio.aws.mediapackagev2.model.GetChannelPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
