package zio.aws.mediapackagev2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EncryptionContractConfiguration(
    presetSpeke20Audio: zio.aws.mediapackagev2.model.PresetSpeke20Audio,
    presetSpeke20Video: zio.aws.mediapackagev2.model.PresetSpeke20Video
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.EncryptionContractConfiguration = {
    import EncryptionContractConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.EncryptionContractConfiguration
      .builder()
      .presetSpeke20Audio(presetSpeke20Audio.unwrap)
      .presetSpeke20Video(presetSpeke20Video.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.EncryptionContractConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.EncryptionContractConfiguration
      .wrap(buildAwsValue())
}
object EncryptionContractConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.EncryptionContractConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagev2.model.EncryptionContractConfiguration =
      zio.aws.mediapackagev2.model
        .EncryptionContractConfiguration(presetSpeke20Audio, presetSpeke20Video)
    def presetSpeke20Audio: zio.aws.mediapackagev2.model.PresetSpeke20Audio
    def presetSpeke20Video: zio.aws.mediapackagev2.model.PresetSpeke20Video
    def getPresetSpeke20Audio
        : ZIO[Any, Nothing, zio.aws.mediapackagev2.model.PresetSpeke20Audio] =
      ZIO.succeed(presetSpeke20Audio)
    def getPresetSpeke20Video
        : ZIO[Any, Nothing, zio.aws.mediapackagev2.model.PresetSpeke20Video] =
      ZIO.succeed(presetSpeke20Video)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.EncryptionContractConfiguration
  ) extends zio.aws.mediapackagev2.model.EncryptionContractConfiguration.ReadOnly {
    override val presetSpeke20Audio
        : zio.aws.mediapackagev2.model.PresetSpeke20Audio =
      zio.aws.mediapackagev2.model.PresetSpeke20Audio
        .wrap(impl.presetSpeke20Audio())
    override val presetSpeke20Video
        : zio.aws.mediapackagev2.model.PresetSpeke20Video =
      zio.aws.mediapackagev2.model.PresetSpeke20Video
        .wrap(impl.presetSpeke20Video())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.EncryptionContractConfiguration
  ): zio.aws.mediapackagev2.model.EncryptionContractConfiguration.ReadOnly =
    new Wrapper(impl)
}
