package zio.aws.mediapackagev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{
  CreateOriginEndpointRequestStartoverWindowSecondsInteger,
  ResourceDescription,
  TagValue,
  IdempotencyToken,
  ResourceName,
  TagKey
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateOriginEndpointRequest(
    channelGroupName: ResourceName,
    channelName: ResourceName,
    originEndpointName: ResourceName,
    containerType: zio.aws.mediapackagev2.model.ContainerType,
    segment: Optional[zio.aws.mediapackagev2.model.Segment] = Optional.Absent,
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent,
    startoverWindowSeconds: Optional[
      CreateOriginEndpointRequestStartoverWindowSecondsInteger
    ] = Optional.Absent,
    hlsManifests: Optional[
      Iterable[zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration]
    ] = Optional.Absent,
    lowLatencyHlsManifests: Optional[Iterable[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
    ]] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest = {
    import CreateOriginEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest
      .builder()
      .channelGroupName(ResourceName.unwrap(channelGroupName): java.lang.String)
      .channelName(ResourceName.unwrap(channelName): java.lang.String)
      .originEndpointName(
        ResourceName.unwrap(originEndpointName): java.lang.String
      )
      .containerType(containerType.unwrap)
      .optionallyWith(segment.map(value => value.buildAwsValue()))(_.segment)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        startoverWindowSeconds.map(value =>
          CreateOriginEndpointRequestStartoverWindowSecondsInteger.unwrap(
            value
          ): Integer
        )
      )(_.startoverWindowSeconds)
      .optionallyWith(
        hlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hlsManifests)
      .optionallyWith(
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lowLatencyHlsManifests)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.CreateOriginEndpointRequest.ReadOnly =
    zio.aws.mediapackagev2.model.CreateOriginEndpointRequest
      .wrap(buildAwsValue())
}
object CreateOriginEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.CreateOriginEndpointRequest =
      zio.aws.mediapackagev2.model.CreateOriginEndpointRequest(
        channelGroupName,
        channelName,
        originEndpointName,
        containerType,
        segment.map(value => value.asEditable),
        clientToken.map(value => value),
        description.map(value => value),
        startoverWindowSeconds.map(value => value),
        hlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lowLatencyHlsManifests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def channelGroupName: ResourceName
    def channelName: ResourceName
    def originEndpointName: ResourceName
    def containerType: zio.aws.mediapackagev2.model.ContainerType
    def segment: Optional[zio.aws.mediapackagev2.model.Segment.ReadOnly]
    def clientToken: Optional[IdempotencyToken]
    def description: Optional[ResourceDescription]
    def startoverWindowSeconds
        : Optional[CreateOriginEndpointRequestStartoverWindowSecondsInteger]
    def hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.ReadOnly]
    ]
    def lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly
    ]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getChannelGroupName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelGroupName)
    def getChannelName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(channelName)
    def getOriginEndpointName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(originEndpointName)
    def getContainerType
        : ZIO[Any, Nothing, zio.aws.mediapackagev2.model.ContainerType] =
      ZIO.succeed(containerType)
    def getSegment
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.Segment.ReadOnly] =
      AwsError.unwrapOptionField("segment", segment)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStartoverWindowSeconds: ZIO[
      Any,
      AwsError,
      CreateOriginEndpointRequestStartoverWindowSecondsInteger
    ] = AwsError.unwrapOptionField(
      "startoverWindowSeconds",
      startoverWindowSeconds
    )
    def getHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("hlsManifests", hlsManifests)
    def getLowLatencyHlsManifests: ZIO[Any, AwsError, List[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lowLatencyHlsManifests",
      lowLatencyHlsManifests
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest
  ) extends zio.aws.mediapackagev2.model.CreateOriginEndpointRequest.ReadOnly {
    override val channelGroupName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.channelGroupName())
    override val channelName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.channelName())
    override val originEndpointName: ResourceName =
      zio.aws.mediapackagev2.model.primitives
        .ResourceName(impl.originEndpointName())
    override val containerType: zio.aws.mediapackagev2.model.ContainerType =
      zio.aws.mediapackagev2.model.ContainerType.wrap(impl.containerType())
    override val segment
        : Optional[zio.aws.mediapackagev2.model.Segment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segment())
        .map(value => zio.aws.mediapackagev2.model.Segment.wrap(value))
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.mediapackagev2.model.primitives.IdempotencyToken(value)
      )
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
    override val startoverWindowSeconds
        : Optional[CreateOriginEndpointRequestStartoverWindowSecondsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startoverWindowSeconds())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives
            .CreateOriginEndpointRequestStartoverWindowSecondsInteger(value)
        )
    override val hlsManifests: Optional[
      List[zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.hlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.CreateHlsManifestConfiguration.wrap(item)
        }.toList
      )
    override val lowLatencyHlsManifests: Optional[List[
      zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.lowLatencyHlsManifests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.mediapackagev2.model.CreateLowLatencyHlsManifestConfiguration
            .wrap(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.mediapackagev2.model.primitives.TagKey(
              key
            ) -> zio.aws.mediapackagev2.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.CreateOriginEndpointRequest
  ): zio.aws.mediapackagev2.model.CreateOriginEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
