package zio.aws.mediapackagev2.model
import scala.jdk.CollectionConverters._
sealed trait ScteFilter {
  def unwrap: software.amazon.awssdk.services.mediapackagev2.model.ScteFilter
}
object ScteFilter {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagev2.model.ScteFilter
  ): zio.aws.mediapackagev2.model.ScteFilter = value match {
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.SPLICE_INSERT =>
      val r = SPLICE_INSERT
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.BREAK =>
      val r = BREAK
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROVIDER_ADVERTISEMENT =>
      val r = PROVIDER_ADVERTISEMENT
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.DISTRIBUTOR_ADVERTISEMENT =>
      val r = DISTRIBUTOR_ADVERTISEMENT
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROVIDER_PLACEMENT_OPPORTUNITY =>
      val r = PROVIDER_PLACEMENT_OPPORTUNITY
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.DISTRIBUTOR_PLACEMENT_OPPORTUNITY =>
      val r = DISTRIBUTOR_PLACEMENT_OPPORTUNITY
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY =>
      val r = PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY =>
      val r = DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY
      r
    case software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROGRAM =>
      val r = PROGRAM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object SPLICE_INSERT extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.SPLICE_INSERT
  }
  case object BREAK extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.BREAK
  }
  case object PROVIDER_ADVERTISEMENT
      extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROVIDER_ADVERTISEMENT
  }
  case object DISTRIBUTOR_ADVERTISEMENT
      extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.DISTRIBUTOR_ADVERTISEMENT
  }
  case object PROVIDER_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROVIDER_PLACEMENT_OPPORTUNITY
  }
  case object DISTRIBUTOR_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.DISTRIBUTOR_PLACEMENT_OPPORTUNITY
  }
  case object PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY
  }
  case object DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY
  }
  case object PROGRAM extends zio.aws.mediapackagev2.model.ScteFilter {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.ScteFilter =
      software.amazon.awssdk.services.mediapackagev2.model.ScteFilter.PROGRAM
  }
}
