package zio.aws.mediapackagev2.model
import zio.aws.mediapackagev2.model.primitives.{Integer, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetLowLatencyHlsManifestConfiguration(
    manifestName: ResourceName,
    url: String,
    childManifestName: Optional[ResourceName] = Optional.Absent,
    manifestWindowSeconds: Optional[Integer] = Optional.Absent,
    programDateTimeIntervalSeconds: Optional[Integer] = Optional.Absent,
    scteHls: Optional[zio.aws.mediapackagev2.model.ScteHls] = Optional.Absent,
    filterConfiguration: Optional[
      zio.aws.mediapackagev2.model.FilterConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration = {
    import GetLowLatencyHlsManifestConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
      .builder()
      .manifestName(ResourceName.unwrap(manifestName): java.lang.String)
      .url(url: java.lang.String)
      .optionallyWith(
        childManifestName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.childManifestName)
      .optionallyWith(
        manifestWindowSeconds.map(value => value: java.lang.Integer)
      )(_.manifestWindowSeconds)
      .optionallyWith(
        programDateTimeIntervalSeconds.map(value => value: java.lang.Integer)
      )(_.programDateTimeIntervalSeconds)
      .optionallyWith(scteHls.map(value => value.buildAwsValue()))(_.scteHls)
      .optionallyWith(filterConfiguration.map(value => value.buildAwsValue()))(
        _.filterConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
      .wrap(buildAwsValue())
}
object GetLowLatencyHlsManifestConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration =
      zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration(
        manifestName,
        url,
        childManifestName.map(value => value),
        manifestWindowSeconds.map(value => value),
        programDateTimeIntervalSeconds.map(value => value),
        scteHls.map(value => value.asEditable),
        filterConfiguration.map(value => value.asEditable)
      )
    def manifestName: ResourceName
    def url: String
    def childManifestName: Optional[ResourceName]
    def manifestWindowSeconds: Optional[Integer]
    def programDateTimeIntervalSeconds: Optional[Integer]
    def scteHls: Optional[zio.aws.mediapackagev2.model.ScteHls.ReadOnly]
    def filterConfiguration
        : Optional[zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly]
    def getManifestName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(manifestName)
    def getUrl: ZIO[Any, Nothing, String] = ZIO.succeed(url)
    def getChildManifestName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("childManifestName", childManifestName)
    def getManifestWindowSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("manifestWindowSeconds", manifestWindowSeconds)
    def getProgramDateTimeIntervalSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "programDateTimeIntervalSeconds",
        programDateTimeIntervalSeconds
      )
    def getScteHls
        : ZIO[Any, AwsError, zio.aws.mediapackagev2.model.ScteHls.ReadOnly] =
      AwsError.unwrapOptionField("scteHls", scteHls)
    def getFilterConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("filterConfiguration", filterConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
  ) extends zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.ReadOnly {
    override val manifestName: ResourceName =
      zio.aws.mediapackagev2.model.primitives.ResourceName(impl.manifestName())
    override val url: String = impl.url(): String
    override val childManifestName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childManifestName())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceName(value)
        )
    override val manifestWindowSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestWindowSeconds())
        .map(value => value: Integer)
    override val programDateTimeIntervalSeconds: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.programDateTimeIntervalSeconds())
        .map(value => value: Integer)
    override val scteHls
        : Optional[zio.aws.mediapackagev2.model.ScteHls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scteHls())
        .map(value => zio.aws.mediapackagev2.model.ScteHls.wrap(value))
    override val filterConfiguration
        : Optional[zio.aws.mediapackagev2.model.FilterConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterConfiguration())
        .map(value =>
          zio.aws.mediapackagev2.model.FilterConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration
  ): zio.aws.mediapackagev2.model.GetLowLatencyHlsManifestConfiguration.ReadOnly =
    new Wrapper(impl)
}
