package zio.aws.mediapackagev2.model
import scala.jdk.CollectionConverters._
sealed trait CmafEncryptionMethod {
  def unwrap: software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod
}
object CmafEncryptionMethod {
  def wrap(
      value: software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod
  ): zio.aws.mediapackagev2.model.CmafEncryptionMethod = value match {
    case software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod.CENC =>
      val r = CENC
      r
    case software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod.CBCS =>
      val r = CBCS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackagev2.model.CmafEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod =
      software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object CENC extends zio.aws.mediapackagev2.model.CmafEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod =
      software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod.CENC
  }
  case object CBCS extends zio.aws.mediapackagev2.model.CmafEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod =
      software.amazon.awssdk.services.mediapackagev2.model.CmafEncryptionMethod.CBCS
  }
}
