package zio.aws.mediapackagev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.mediapackagev2.model.primitives.{ResourceDescription, Timestamp}
import scala.jdk.CollectionConverters._
final case class ChannelGroupListConfiguration(
    channelGroupName: String,
    arn: String,
    createdAt: Timestamp,
    modifiedAt: Timestamp,
    description: Optional[ResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackagev2.model.ChannelGroupListConfiguration = {
    import ChannelGroupListConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackagev2.model.ChannelGroupListConfiguration
      .builder()
      .channelGroupName(channelGroupName: java.lang.String)
      .arn(arn: java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .modifiedAt(Timestamp.unwrap(modifiedAt): Instant)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly =
    zio.aws.mediapackagev2.model.ChannelGroupListConfiguration
      .wrap(buildAwsValue())
}
object ChannelGroupListConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackagev2.model.ChannelGroupListConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackagev2.model.ChannelGroupListConfiguration =
      zio.aws.mediapackagev2.model.ChannelGroupListConfiguration(
        channelGroupName,
        arn,
        createdAt,
        modifiedAt,
        description.map(value => value)
      )
    def channelGroupName: String
    def arn: String
    def createdAt: Timestamp
    def modifiedAt: Timestamp
    def description: Optional[ResourceDescription]
    def getChannelGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(channelGroupName)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getModifiedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modifiedAt)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ChannelGroupListConfiguration
  ) extends zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly {
    override val channelGroupName: String = impl.channelGroupName(): String
    override val arn: String = impl.arn(): String
    override val createdAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.createdAt())
    override val modifiedAt: Timestamp =
      zio.aws.mediapackagev2.model.primitives.Timestamp(impl.modifiedAt())
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.mediapackagev2.model.primitives.ResourceDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackagev2.model.ChannelGroupListConfiguration
  ): zio.aws.mediapackagev2.model.ChannelGroupListConfiguration.ReadOnly =
    new Wrapper(impl)
}
