package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters.*
sealed trait CmafEncryptionMethod {
  def unwrap
      : software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod
}
object CmafEncryptionMethod {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod
  ): zio.aws.mediapackage.model.CmafEncryptionMethod = value match {
    case software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod.SAMPLE_AES =>
      val r = SAMPLE_AES
      r
    case software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod.AES_CTR =>
      val r = AES_CTR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.CmafEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod =
      software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object SAMPLE_AES
      extends zio.aws.mediapackage.model.CmafEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod =
      software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod.SAMPLE_AES
  }
  case object AES_CTR extends zio.aws.mediapackage.model.CmafEncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod =
      software.amazon.awssdk.services.mediapackage.model.CmafEncryptionMethod.AES_CTR
  }
}
