package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeHarvestJobResponse(
    arn: Optional[__string] = Optional.Absent,
    channelId: Optional[__string] = Optional.Absent,
    createdAt: Optional[__string] = Optional.Absent,
    endTime: Optional[__string] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    originEndpointId: Optional[__string] = Optional.Absent,
    s3Destination: Optional[zio.aws.mediapackage.model.S3Destination] =
      Optional.Absent,
    startTime: Optional[__string] = Optional.Absent,
    status: Optional[zio.aws.mediapackage.model.Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse = {
    import DescribeHarvestJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(createdAt.map(value => value: java.lang.String))(
        _.createdAt
      )
      .optionallyWith(endTime.map(value => value: java.lang.String))(_.endTime)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(originEndpointId.map(value => value: java.lang.String))(
        _.originEndpointId
      )
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .optionallyWith(startTime.map(value => value: java.lang.String))(
        _.startTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly =
    zio.aws.mediapackage.model.DescribeHarvestJobResponse.wrap(buildAwsValue())
}
object DescribeHarvestJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.DescribeHarvestJobResponse =
      zio.aws.mediapackage.model.DescribeHarvestJobResponse(
        arn.map(value => value),
        channelId.map(value => value),
        createdAt.map(value => value),
        endTime.map(value => value),
        id.map(value => value),
        originEndpointId.map(value => value),
        s3Destination.map(value => value.asEditable),
        startTime.map(value => value),
        status.map(value => value)
      )
    def arn: Optional[__string]
    def channelId: Optional[__string]
    def createdAt: Optional[__string]
    def endTime: Optional[__string]
    def id: Optional[__string]
    def originEndpointId: Optional[__string]
    def s3Destination
        : Optional[zio.aws.mediapackage.model.S3Destination.ReadOnly]
    def startTime: Optional[__string]
    def status: Optional[zio.aws.mediapackage.model.Status]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getCreatedAt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getEndTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getOriginEndpointId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originEndpointId", originEndpointId)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.S3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
    def getStartTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.mediapackage.model.Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
  ) extends zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val channelId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.channelId())
      .map(value => value: __string)
    override val createdAt: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __string)
    override val endTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __string)
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val originEndpointId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.originEndpointId())
      .map(value => value: __string)
    override val s3Destination
        : Optional[zio.aws.mediapackage.model.S3Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Destination())
        .map(value => zio.aws.mediapackage.model.S3Destination.wrap(value))
    override val startTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: __string)
    override val status: Optional[zio.aws.mediapackage.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.mediapackage.model.Status.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.DescribeHarvestJobResponse
  ): zio.aws.mediapackage.model.DescribeHarvestJobResponse.ReadOnly =
    new Wrapper(impl)
}
