package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters.*
sealed trait AdTriggersElement {
  def unwrap
      : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement
}
object AdTriggersElement {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.AdTriggersElement
  ): zio.aws.mediapackage.model.AdTriggersElement = value match {
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.SPLICE_INSERT =>
      val r = SPLICE_INSERT
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.BREAK =>
      val r = BREAK
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.PROVIDER_ADVERTISEMENT =>
      val r = PROVIDER_ADVERTISEMENT
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.DISTRIBUTOR_ADVERTISEMENT =>
      val r = DISTRIBUTOR_ADVERTISEMENT
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.PROVIDER_PLACEMENT_OPPORTUNITY =>
      val r = PROVIDER_PLACEMENT_OPPORTUNITY
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.DISTRIBUTOR_PLACEMENT_OPPORTUNITY =>
      val r = DISTRIBUTOR_PLACEMENT_OPPORTUNITY
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY =>
      val r = PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY
      r
    case software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY =>
      val r = DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.UNKNOWN_TO_SDK_VERSION
  }
  case object SPLICE_INSERT
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.SPLICE_INSERT
  }
  case object BREAK extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.BREAK
  }
  case object PROVIDER_ADVERTISEMENT
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.PROVIDER_ADVERTISEMENT
  }
  case object DISTRIBUTOR_ADVERTISEMENT
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.DISTRIBUTOR_ADVERTISEMENT
  }
  case object PROVIDER_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.PROVIDER_PLACEMENT_OPPORTUNITY
  }
  case object DISTRIBUTOR_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.DISTRIBUTOR_PLACEMENT_OPPORTUNITY
  }
  case object PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.PROVIDER_OVERLAY_PLACEMENT_OPPORTUNITY
  }
  case object DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY
      extends zio.aws.mediapackage.model.AdTriggersElement {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.AdTriggersElement =
      software.amazon.awssdk.services.mediapackage.model.AdTriggersElement.DISTRIBUTOR_OVERLAY_PLACEMENT_OPPORTUNITY
  }
}
