package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.{__integer, __boolean}
import scala.jdk.CollectionConverters.*
final case class HlsPackage(
    adMarkers: Optional[zio.aws.mediapackage.model.AdMarkers] = Optional.Absent,
    adTriggers: Optional[
      Iterable[zio.aws.mediapackage.model.AdTriggersElement]
    ] = Optional.Absent,
    adsOnDeliveryRestrictions: Optional[
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = Optional.Absent,
    encryption: Optional[zio.aws.mediapackage.model.HlsEncryption] =
      Optional.Absent,
    includeDvbSubtitles: Optional[__boolean] = Optional.Absent,
    includeIframeOnlyStream: Optional[__boolean] = Optional.Absent,
    playlistType: Optional[zio.aws.mediapackage.model.PlaylistType] =
      Optional.Absent,
    playlistWindowSeconds: Optional[__integer] = Optional.Absent,
    programDateTimeIntervalSeconds: Optional[__integer] = Optional.Absent,
    segmentDurationSeconds: Optional[__integer] = Optional.Absent,
    streamSelection: Optional[zio.aws.mediapackage.model.StreamSelection] =
      Optional.Absent,
    useAudioRenditionGroup: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.HlsPackage = {
    import HlsPackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.HlsPackage
      .builder()
      .optionallyWith(adMarkers.map(value => value.unwrap))(_.adMarkers)
      .optionallyWith(
        adTriggers.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.adTriggersWithStrings)
      .optionallyWith(adsOnDeliveryRestrictions.map(value => value.unwrap))(
        _.adsOnDeliveryRestrictions
      )
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(
        includeDvbSubtitles.map(value => value: java.lang.Boolean)
      )(_.includeDvbSubtitles)
      .optionallyWith(
        includeIframeOnlyStream.map(value => value: java.lang.Boolean)
      )(_.includeIframeOnlyStream)
      .optionallyWith(playlistType.map(value => value.unwrap))(_.playlistType)
      .optionallyWith(playlistWindowSeconds.map(value => value: Integer))(
        _.playlistWindowSeconds
      )
      .optionallyWith(
        programDateTimeIntervalSeconds.map(value => value: Integer)
      )(_.programDateTimeIntervalSeconds)
      .optionallyWith(segmentDurationSeconds.map(value => value: Integer))(
        _.segmentDurationSeconds
      )
      .optionallyWith(streamSelection.map(value => value.buildAwsValue()))(
        _.streamSelection
      )
      .optionallyWith(
        useAudioRenditionGroup.map(value => value: java.lang.Boolean)
      )(_.useAudioRenditionGroup)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.HlsPackage.ReadOnly =
    zio.aws.mediapackage.model.HlsPackage.wrap(buildAwsValue())
}
object HlsPackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.HlsPackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.HlsPackage =
      zio.aws.mediapackage.model.HlsPackage(
        adMarkers.map(value => value),
        adTriggers.map(value => value),
        adsOnDeliveryRestrictions.map(value => value),
        encryption.map(value => value.asEditable),
        includeDvbSubtitles.map(value => value),
        includeIframeOnlyStream.map(value => value),
        playlistType.map(value => value),
        playlistWindowSeconds.map(value => value),
        programDateTimeIntervalSeconds.map(value => value),
        segmentDurationSeconds.map(value => value),
        streamSelection.map(value => value.asEditable),
        useAudioRenditionGroup.map(value => value)
      )
    def adMarkers: Optional[zio.aws.mediapackage.model.AdMarkers]
    def adTriggers: Optional[List[zio.aws.mediapackage.model.AdTriggersElement]]
    def adsOnDeliveryRestrictions
        : Optional[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions]
    def encryption: Optional[zio.aws.mediapackage.model.HlsEncryption.ReadOnly]
    def includeDvbSubtitles: Optional[__boolean]
    def includeIframeOnlyStream: Optional[__boolean]
    def playlistType: Optional[zio.aws.mediapackage.model.PlaylistType]
    def playlistWindowSeconds: Optional[__integer]
    def programDateTimeIntervalSeconds: Optional[__integer]
    def segmentDurationSeconds: Optional[__integer]
    def streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly]
    def useAudioRenditionGroup: Optional[__boolean]
    def getAdMarkers: ZIO[Any, AwsError, zio.aws.mediapackage.model.AdMarkers] =
      AwsError.unwrapOptionField("adMarkers", adMarkers)
    def getAdTriggers: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.AdTriggersElement
    ]] = AwsError.unwrapOptionField("adTriggers", adTriggers)
    def getAdsOnDeliveryRestrictions: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.AdsOnDeliveryRestrictions
    ] = AwsError.unwrapOptionField(
      "adsOnDeliveryRestrictions",
      adsOnDeliveryRestrictions
    )
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.HlsEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getIncludeDvbSubtitles: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("includeDvbSubtitles", includeDvbSubtitles)
    def getIncludeIframeOnlyStream: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("includeIframeOnlyStream", includeIframeOnlyStream)
    def getPlaylistType
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.PlaylistType] =
      AwsError.unwrapOptionField("playlistType", playlistType)
    def getPlaylistWindowSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("playlistWindowSeconds", playlistWindowSeconds)
    def getProgramDateTimeIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "programDateTimeIntervalSeconds",
        programDateTimeIntervalSeconds
      )
    def getSegmentDurationSeconds: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("segmentDurationSeconds", segmentDurationSeconds)
    def getStreamSelection: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.StreamSelection.ReadOnly
    ] = AwsError.unwrapOptionField("streamSelection", streamSelection)
    def getUseAudioRenditionGroup: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("useAudioRenditionGroup", useAudioRenditionGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsPackage
  ) extends zio.aws.mediapackage.model.HlsPackage.ReadOnly {
    override val adMarkers: Optional[zio.aws.mediapackage.model.AdMarkers] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adMarkers())
        .map(value => zio.aws.mediapackage.model.AdMarkers.wrap(value))
    override val adTriggers
        : Optional[List[zio.aws.mediapackage.model.AdTriggersElement]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adTriggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.AdTriggersElement.wrap(item)
          }.toList
        )
    override val adsOnDeliveryRestrictions
        : Optional[zio.aws.mediapackage.model.AdsOnDeliveryRestrictions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adsOnDeliveryRestrictions())
        .map(value =>
          zio.aws.mediapackage.model.AdsOnDeliveryRestrictions.wrap(value)
        )
    override val encryption
        : Optional[zio.aws.mediapackage.model.HlsEncryption.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryption())
        .map(value => zio.aws.mediapackage.model.HlsEncryption.wrap(value))
    override val includeDvbSubtitles: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeDvbSubtitles())
        .map(value => value: __boolean)
    override val includeIframeOnlyStream: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeIframeOnlyStream())
        .map(value => value: __boolean)
    override val playlistType
        : Optional[zio.aws.mediapackage.model.PlaylistType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playlistType())
        .map(value => zio.aws.mediapackage.model.PlaylistType.wrap(value))
    override val playlistWindowSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playlistWindowSeconds())
        .map(value => value: __integer)
    override val programDateTimeIntervalSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.programDateTimeIntervalSeconds())
        .map(value => value: __integer)
    override val segmentDurationSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentDurationSeconds())
        .map(value => value: __integer)
    override val streamSelection
        : Optional[zio.aws.mediapackage.model.StreamSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamSelection())
        .map(value => zio.aws.mediapackage.model.StreamSelection.wrap(value))
    override val useAudioRenditionGroup: Optional[__boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useAudioRenditionGroup())
        .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsPackage
  ): zio.aws.mediapackage.model.HlsPackage.ReadOnly = new Wrapper(impl)
}
