package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeChannelResponse(
    arn: Optional[__string] = Optional.Absent,
    createdAt: Optional[__string] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    egressAccessLogs: Optional[zio.aws.mediapackage.model.EgressAccessLogs] =
      Optional.Absent,
    hlsIngest: Optional[zio.aws.mediapackage.model.HlsIngest] = Optional.Absent,
    id: Optional[__string] = Optional.Absent,
    ingressAccessLogs: Optional[zio.aws.mediapackage.model.IngressAccessLogs] =
      Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.DescribeChannelResponse = {
    import DescribeChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.DescribeChannelResponse
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: java.lang.String))(
        _.createdAt
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(egressAccessLogs.map(value => value.buildAwsValue()))(
        _.egressAccessLogs
      )
      .optionallyWith(hlsIngest.map(value => value.buildAwsValue()))(
        _.hlsIngest
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(ingressAccessLogs.map(value => value.buildAwsValue()))(
        _.ingressAccessLogs
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly =
    zio.aws.mediapackage.model.DescribeChannelResponse.wrap(buildAwsValue())
}
object DescribeChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.DescribeChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.DescribeChannelResponse =
      zio.aws.mediapackage.model.DescribeChannelResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        description.map(value => value),
        egressAccessLogs.map(value => value.asEditable),
        hlsIngest.map(value => value.asEditable),
        id.map(value => value),
        ingressAccessLogs.map(value => value.asEditable),
        tags.map(value => value)
      )
    def arn: Optional[__string]
    def createdAt: Optional[__string]
    def description: Optional[__string]
    def egressAccessLogs
        : Optional[zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly]
    def hlsIngest: Optional[zio.aws.mediapackage.model.HlsIngest.ReadOnly]
    def id: Optional[__string]
    def ingressAccessLogs
        : Optional[zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly]
    def tags: Optional[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getEgressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("egressAccessLogs", egressAccessLogs)
    def getHlsIngest
        : ZIO[Any, AwsError, zio.aws.mediapackage.model.HlsIngest.ReadOnly] =
      AwsError.unwrapOptionField("hlsIngest", hlsIngest)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIngressAccessLogs: ZIO[
      Any,
      AwsError,
      zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly
    ] = AwsError.unwrapOptionField("ingressAccessLogs", ingressAccessLogs)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.DescribeChannelResponse
  ) extends zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val createdAt: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => value: __string)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val egressAccessLogs
        : Optional[zio.aws.mediapackage.model.EgressAccessLogs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressAccessLogs())
        .map(value => zio.aws.mediapackage.model.EgressAccessLogs.wrap(value))
    override val hlsIngest
        : Optional[zio.aws.mediapackage.model.HlsIngest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hlsIngest())
        .map(value => zio.aws.mediapackage.model.HlsIngest.wrap(value))
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val ingressAccessLogs
        : Optional[zio.aws.mediapackage.model.IngressAccessLogs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingressAccessLogs())
        .map(value => zio.aws.mediapackage.model.IngressAccessLogs.wrap(value))
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.DescribeChannelResponse
  ): zio.aws.mediapackage.model.DescribeChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
