package zio.aws.mediapackage.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.mediapackage.model.primitives.__integer
import scala.jdk.CollectionConverters.*
final case class DashEncryption(
    keyRotationIntervalSeconds: Optional[__integer] = Optional.Absent,
    spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.DashEncryption = {
    import DashEncryption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.DashEncryption
      .builder()
      .optionallyWith(keyRotationIntervalSeconds.map(value => value: Integer))(
        _.keyRotationIntervalSeconds
      )
      .spekeKeyProvider(spekeKeyProvider.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.DashEncryption.ReadOnly =
    zio.aws.mediapackage.model.DashEncryption.wrap(buildAwsValue())
}
object DashEncryption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.DashEncryption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.DashEncryption =
      zio.aws.mediapackage.model.DashEncryption(
        keyRotationIntervalSeconds.map(value => value),
        spekeKeyProvider.asEditable
      )
    def keyRotationIntervalSeconds: Optional[__integer]
    def spekeKeyProvider: zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    def getKeyRotationIntervalSeconds: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "keyRotationIntervalSeconds",
        keyRotationIntervalSeconds
      )
    def getSpekeKeyProvider: ZIO[
      Any,
      Nothing,
      zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly
    ] = ZIO.succeed(spekeKeyProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.DashEncryption
  ) extends zio.aws.mediapackage.model.DashEncryption.ReadOnly {
    override val keyRotationIntervalSeconds: Optional[__integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyRotationIntervalSeconds())
        .map(value => value: __integer)
    override val spekeKeyProvider
        : zio.aws.mediapackage.model.SpekeKeyProvider.ReadOnly =
      zio.aws.mediapackage.model.SpekeKeyProvider.wrap(impl.spekeKeyProvider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.DashEncryption
  ): zio.aws.mediapackage.model.DashEncryption.ReadOnly = new Wrapper(impl)
}
