package zio.aws.mediapackage.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionMethod {
  def unwrap
      : software.amazon.awssdk.services.mediapackage.model.EncryptionMethod
}
object EncryptionMethod {
  def wrap(
      value: software.amazon.awssdk.services.mediapackage.model.EncryptionMethod
  ): zio.aws.mediapackage.model.EncryptionMethod = value match {
    case software.amazon.awssdk.services.mediapackage.model.EncryptionMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.mediapackage.model.EncryptionMethod.AES_128 =>
      val r = AES_128
      r
    case software.amazon.awssdk.services.mediapackage.model.EncryptionMethod.SAMPLE_AES =>
      val r = SAMPLE_AES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.mediapackage.model.EncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.EncryptionMethod =
      software.amazon.awssdk.services.mediapackage.model.EncryptionMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object AES_128 extends zio.aws.mediapackage.model.EncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.EncryptionMethod =
      software.amazon.awssdk.services.mediapackage.model.EncryptionMethod.AES_128
  }
  case object SAMPLE_AES extends zio.aws.mediapackage.model.EncryptionMethod {
    override def unwrap
        : software.amazon.awssdk.services.mediapackage.model.EncryptionMethod =
      software.amazon.awssdk.services.mediapackage.model.EncryptionMethod.SAMPLE_AES
  }
}
