package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListChannelsResponse(
    channels: Optional[Iterable[zio.aws.mediapackage.model.Channel]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly =
    zio.aws.mediapackage.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.ListChannelsResponse =
      zio.aws.mediapackage.model.ListChannelsResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channels: Optional[List[zio.aws.mediapackage.model.Channel.ReadOnly]]
    def nextToken: Optional[__string]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.Channel.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
  ) extends zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly {
    override val channels
        : Optional[List[zio.aws.mediapackage.model.Channel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.Channel.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse
  ): zio.aws.mediapackage.model.ListChannelsResponse.ReadOnly = new Wrapper(
    impl
  )
}
