package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IngestEndpoint(
    id: Optional[__string] = Optional.Absent,
    password: Optional[__string] = Optional.Absent,
    url: Optional[__string] = Optional.Absent,
    username: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.IngestEndpoint = {
    import IngestEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(password.map(value => value: java.lang.String))(
        _.password
      )
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.IngestEndpoint.ReadOnly =
    zio.aws.mediapackage.model.IngestEndpoint.wrap(buildAwsValue())
}
object IngestEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.IngestEndpoint =
      zio.aws.mediapackage.model.IngestEndpoint(
        id.map(value => value),
        password.map(value => value),
        url.map(value => value),
        username.map(value => value)
      )
    def id: Optional[__string]
    def password: Optional[__string]
    def url: Optional[__string]
    def username: Optional[__string]
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getPassword: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("password", password)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
    def getUsername: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
  ) extends zio.aws.mediapackage.model.IngestEndpoint.ReadOnly {
    override val id: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: __string)
    override val password: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => value: __string)
    override val url: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: __string)
    override val username: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.IngestEndpoint
  ): zio.aws.mediapackage.model.IngestEndpoint.ReadOnly = new Wrapper(impl)
}
