package zio.aws.mediapackage.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HlsIngest(
    ingestEndpoints: Optional[
      Iterable[zio.aws.mediapackage.model.IngestEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.HlsIngest = {
    import HlsIngest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.HlsIngest
      .builder()
      .optionallyWith(
        ingestEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ingestEndpoints)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.HlsIngest.ReadOnly =
    zio.aws.mediapackage.model.HlsIngest.wrap(buildAwsValue())
}
object HlsIngest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.HlsIngest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.HlsIngest =
      zio.aws.mediapackage.model.HlsIngest(
        ingestEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ingestEndpoints
        : Optional[List[zio.aws.mediapackage.model.IngestEndpoint.ReadOnly]]
    def getIngestEndpoints: ZIO[Any, AwsError, List[
      zio.aws.mediapackage.model.IngestEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("ingestEndpoints", ingestEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsIngest
  ) extends zio.aws.mediapackage.model.HlsIngest.ReadOnly {
    override val ingestEndpoints
        : Optional[List[zio.aws.mediapackage.model.IngestEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.mediapackage.model.IngestEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.HlsIngest
  ): zio.aws.mediapackage.model.HlsIngest.ReadOnly = new Wrapper(impl)
}
