package zio.aws.mediapackage.model
import zio.aws.mediapackage.model.primitives.__string
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3Destination(
    bucketName: __string,
    manifestKey: __string,
    roleArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.mediapackage.model.S3Destination = {
    import S3Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.mediapackage.model.S3Destination
      .builder()
      .bucketName(bucketName: java.lang.String)
      .manifestKey(manifestKey: java.lang.String)
      .roleArn(roleArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.mediapackage.model.S3Destination.ReadOnly =
    zio.aws.mediapackage.model.S3Destination.wrap(buildAwsValue())
}
object S3Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.mediapackage.model.S3Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.mediapackage.model.S3Destination =
      zio.aws.mediapackage.model.S3Destination(bucketName, manifestKey, roleArn)
    def bucketName: __string
    def manifestKey: __string
    def roleArn: __string
    def getBucketName: ZIO[Any, Nothing, __string] = ZIO.succeed(bucketName)
    def getManifestKey: ZIO[Any, Nothing, __string] = ZIO.succeed(manifestKey)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.mediapackage.model.S3Destination
  ) extends zio.aws.mediapackage.model.S3Destination.ReadOnly {
    override val bucketName: __string = impl.bucketName(): __string
    override val manifestKey: __string = impl.manifestKey(): __string
    override val roleArn: __string = impl.roleArn(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.mediapackage.model.S3Destination
  ): zio.aws.mediapackage.model.S3Destination.ReadOnly = new Wrapper(impl)
}
